/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings.render;

import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.buildings.placeable.blocks.PlaceableBlock;
import joshie.harvest.buildings.placeable.blocks.PlaceableDouble;
import joshie.harvest.buildings.placeable.blocks.PlaceableDoubleOpposite;
import joshie.harvest.buildings.render.BuildingVertexUploader;
import joshie.harvest.buildings.render.RenderKey;
import joshie.harvest.core.util.Direction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BuildingRenderer {
    private final RegionRenderCacheBuilder renderer;
    private final RenderKey key;
    private BlockPos pos;

    public BuildingRenderer(IBlockAccess world, RenderKey key) {
        BuildingImpl building = key.getBuilding();
        this.key = key;
        this.pos = key.getPos();
        this.renderer = new RegionRenderCacheBuilder();
        Direction direction = Direction.withMirrorAndRotation(key.getMirror(), key.getRotation());
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            VertexBuffer buffer = this.renderer.func_179038_a(layer);
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            if (HFBuildings.FULL_BUILDING_RENDER) {
                for (Placeable placeable : building.getFullList()) {
                    PlaceableBlock block;
                    if (placeable.getY() < -building.getOffsetY() || !(placeable instanceof PlaceableBlock) || (block = (PlaceableBlock)placeable).getBlock() == Blocks.field_150350_a) continue;
                    this.addRender(world, block, direction, layer, buffer);
                }
                continue;
            }
            for (PlaceableBlock block : building.getPreviewList()) {
                this.addRender(world, block, direction, layer, buffer);
            }
        }
    }

    private void addRender(IBlockAccess world, PlaceableBlock block, Direction direction, BlockRenderLayer layer, VertexBuffer buffer) {
        IBlockState state = block.getTransformedState(direction);
        if (state.func_177230_c().canRenderInLayer(state, layer)) {
            Minecraft.func_71410_x().func_175602_ab().func_175018_a(state, block.transformBlockPos(direction), world, buffer);
            if (block instanceof PlaceableDouble) {
                state = state.func_177230_c().func_176203_a(8);
                Minecraft.func_71410_x().func_175602_ab().func_175018_a(state, block.transformBlockPos(direction).func_177984_a(), world, buffer);
            } else if (block instanceof PlaceableDoubleOpposite) {
                state = state.func_177230_c().func_176203_a(9);
                Minecraft.func_71410_x().func_175602_ab().func_175018_a(state, block.transformBlockPos(direction).func_177984_a(), world, buffer);
            }
        }
    }

    public BuildingRenderer setPosition(BlockPos position) {
        this.pos = position;
        return this;
    }

    public BuildingImpl getBuilding() {
        return this.key.getBuilding();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void draw(BuildingVertexUploader vertexUploader) {
        GlStateManager.func_179118_c();
        vertexUploader.func_181679_a(this.renderer.func_179038_a(BlockRenderLayer.SOLID));
        GlStateManager.func_179141_d();
        vertexUploader.func_181679_a(this.renderer.func_179038_a(BlockRenderLayer.CUTOUT_MIPPED));
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        vertexUploader.func_181679_a(this.renderer.func_179038_a(BlockRenderLayer.CUTOUT));
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)false);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179103_j((int)7425);
        vertexUploader.func_181679_a(this.renderer.func_179038_a(BlockRenderLayer.TRANSLUCENT));
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildingRenderer renderer = (BuildingRenderer)o;
        return this.key != null ? this.key.equals(renderer.key) : renderer.key == null;
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }
}

