/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings.placeable.entities;

import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.buildings.placeable.entities.PlaceableEntity;
import joshie.harvest.core.util.Direction;
import joshie.harvest.npc.NPC;
import joshie.harvest.npc.NPCHelper;
import joshie.harvest.npc.NPCRegistry;
import joshie.harvest.npc.entity.EntityNPC;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PlaceableNPC
extends PlaceableEntity {
    private String homeString;
    private String npc;

    public PlaceableNPC() {
    }

    public PlaceableNPC(String homeString, String npc, int x, int y, int z) {
        this.homeString = homeString;
        this.npc = npc;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public boolean canPlace(Placeable.ConstructionStage stage) {
        return stage == Placeable.ConstructionStage.MOVEIN;
    }

    @Override
    public Entity getEntity(World world, BlockPos pos, Direction direction) {
        if (this.npc == null || this.npc.equals("")) {
            return null;
        }
        NPC inpc = (NPC)NPCRegistry.REGISTRY.getValue(new ResourceLocation(this.npc));
        if (inpc == null) {
            return null;
        }
        Object entity = NPCHelper.getEntityForNPC(world, inpc);
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        ((EntityNPC)((Object)entity)).resetSpawnHome();
        return entity;
    }

    @Override
    public PlaceableNPC getCopyFromEntity(Entity e, int x, int y, int z) {
        EntityNPC npc = (EntityNPC)e;
        return new PlaceableNPC("", npc.getNPC().getRegistryName().toString(), x, y, z);
    }

    public String getHomeString() {
        return this.homeString;
    }
}

