/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings.placeable.entities;

import joshie.harvest.buildings.LootHelper;
import joshie.harvest.buildings.placeable.entities.PlaceableHanging;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PlaceableItemFrame
extends PlaceableHanging {
    private ResourceLocation chestType;
    private ItemStack stack;
    private int rotation;

    public PlaceableItemFrame() {
    }

    public PlaceableItemFrame(ResourceLocation chestType, ItemStack stack, int rotation, EnumFacing facing, int x, int y, int z) {
        super(facing, x, y, z);
        this.chestType = chestType;
        this.stack = stack;
        this.rotation = rotation;
    }

    @Override
    public EntityHanging getEntityHanging(World world, BlockPos pos, EnumFacing facing) {
        EntityItemFrame frame = new EntityItemFrame(world, new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), facing);
        ItemStack loot = null;
        if (this.stack != null) {
            loot = this.stack.func_77946_l();
        }
        if (this.chestType != null) {
            loot = LootHelper.getStack(world, null, this.chestType);
        }
        frame.func_82334_a(loot);
        frame.func_82336_g(this.rotation);
        return frame;
    }

    @Override
    public PlaceableItemFrame getCopyFromEntity(Entity e, int x, int y, int z) {
        EntityItemFrame frame = (EntityItemFrame)e;
        ResourceLocation chestType = null;
        ItemStack stack = frame.func_82335_i();
        if (stack != null && stack.func_82837_s()) {
            chestType = new ResourceLocation("harvestfestival", "frames/" + stack.func_82833_r());
            stack = new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i());
        }
        return new PlaceableItemFrame(chestType, stack, frame.func_82333_j(), frame.field_174860_b, x, y, z);
    }
}

