/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings.placeable.blocks;

import java.util.EnumMap;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.core.util.Direction;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PlaceableBlock
extends Placeable {
    protected transient EnumMap<Direction, IBlockState> states = new EnumMap(Direction.class);
    protected IBlockState state;

    public PlaceableBlock() {
    }

    public PlaceableBlock(BlockPos pos, PlaceableBlock block) {
        this.state = block.state;
        for (Direction direction : Direction.values()) {
            this.states.put(direction, direction.withDirection(this.state));
        }
    }

    public PlaceableBlock(IBlockState state, int x, int y, int z) {
        this.state = state;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PlaceableBlock(IBlockState state, BlockPos pos) {
        this.state = state;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    @Override
    public PlaceableBlock init() {
        if (this.states == null) {
            this.states = new EnumMap(Direction.class);
        }
        for (Direction direction : Direction.values()) {
            this.states.put(direction, direction.withDirection(this.state));
        }
        return this;
    }

    public boolean isBlocked(World world, BlockPos pos) {
        return false;
    }

    public Block getBlock() {
        return this.state.func_177230_c();
    }

    public IBlockState getState() {
        return this.state;
    }

    public IBlockState getTransformedState(Direction direction) {
        return direction.withDirection(this.state);
    }

    public PlaceableBlock copyWithOffset(BlockPos pos, Direction direction) {
        return new PlaceableBlock(this.getTransformedPosition(pos, direction), this);
    }

    @Override
    public boolean canPlace(Placeable.ConstructionStage stage) {
        return stage == Placeable.ConstructionStage.BUILD;
    }

    public boolean prePlace(World world, BlockPos pos, Direction direction) {
        return world.func_180495_p(pos).func_185887_b(world, pos) != -1.0f;
    }

    @Override
    public final boolean place(World world, BlockPos pos, Direction direction, boolean playSound) {
        boolean result;
        if (!this.prePlace(world, pos, direction)) {
            return false;
        }
        IBlockState state = this.getTransformedState(direction);
        if (world.func_180495_p(pos) == state) {
            return false;
        }
        if (playSound) {
            world.func_180498_a(null, 2001, pos, Block.func_176210_f((IBlockState)state));
        }
        if (result = world.func_180501_a(pos, state, 2)) {
            this.postPlace(world, pos, direction);
        }
        return result;
    }

    public void postPlace(World world, BlockPos pos, Direction direction) {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlaceableBlock)) {
            return false;
        }
        PlaceableBlock other = (PlaceableBlock)obj;
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        return this.getZ() == other.getZ();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.getX();
        result = prime * result + this.getY();
        result = prime * result + this.getZ();
        return result;
    }
}

