/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings.placeable;

import java.util.HashMap;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.buildings.placeable.blocks.PlaceableBlock;
import joshie.harvest.buildings.placeable.blocks.PlaceableDecorative;
import joshie.harvest.buildings.placeable.blocks.PlaceableDouble;
import joshie.harvest.buildings.placeable.blocks.PlaceableDoubleOpposite;
import joshie.harvest.buildings.placeable.blocks.PlaceableFlowerPot;
import joshie.harvest.buildings.placeable.blocks.PlaceableFurnace;
import joshie.harvest.buildings.placeable.blocks.PlaceableMoveIn;
import joshie.harvest.buildings.placeable.blocks.PlaceableSign;
import joshie.harvest.buildings.placeable.blocks.PlaceableWeb;
import joshie.harvest.buildings.placeable.entities.PlaceableEntity;
import joshie.harvest.buildings.placeable.entities.PlaceableItemFrame;
import joshie.harvest.buildings.placeable.entities.PlaceableNPC;
import joshie.harvest.buildings.placeable.entities.PlaceablePainting;
import joshie.harvest.mining.block.BlockPortal;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class PlaceableHelper {
    public static final HashMap<String, PlaceableEntity> entities = new HashMap();

    private static Placeable getPrefixString(World world, IBlockState state, int x, int y, int z) {
        Block block = state.func_177230_c();
        if (block instanceof BlockPortal) {
            return new PlaceableMoveIn(state, x, y, z);
        }
        if (block == HFBuildings.AIR) {
            return new PlaceableBlock(Blocks.field_150350_a.func_176223_P(), x, y, z);
        }
        if (block instanceof BlockTorch) {
            return new PlaceableDecorative(state, x, y, z);
        }
        if (block instanceof BlockLever || block == Blocks.field_150355_j) {
            return new PlaceableDecorative(state, x, y, z);
        }
        if (block instanceof BlockButton) {
            return new PlaceableDecorative(state, x, y, z);
        }
        if (block instanceof BlockDoor || block instanceof BlockDoublePlant) {
            IBlockState above = world.func_180495_p(new BlockPos(x, y + 1, z));
            if (above.func_177230_c().func_176201_c(above) == 9) {
                return new PlaceableDoubleOpposite(state, x, y, z);
            }
            return new PlaceableDouble(state, x, y, z);
        }
        if (block instanceof BlockLilyPad) {
            return new PlaceableDecorative(state, x, y, z);
        }
        if (block instanceof BlockCocoa) {
            return new PlaceableDecorative(state, x, y, z);
        }
        if (block instanceof BlockAnvil) {
            return new PlaceableDecorative(state, x, y, z);
        }
        if (block instanceof BlockFurnace || block instanceof BlockEnderChest) {
            return new PlaceableFurnace(state, x, y, z);
        }
        if (block instanceof BlockLadder) {
            return new PlaceableDecorative(state, x, y, z);
        }
        if (block instanceof BlockPumpkin) {
            return new PlaceableDecorative(state, x, y, z);
        }
        if (block instanceof BlockTrapDoor) {
            return new PlaceableDecorative(state, x, y, z);
        }
        if (block instanceof BlockVine) {
            return new PlaceableDecorative(state, x, y, z);
        }
        if (block instanceof BlockWeb) {
            return new PlaceableWeb(state, x, y, z);
        }
        if (block instanceof BlockFlowerPot) {
            return new PlaceableFlowerPot(state, x, y, z);
        }
        if (block instanceof BlockMushroom) {
            return new PlaceableDecorative(state, x, y, z);
        }
        if (block instanceof BlockFlower) {
            return new PlaceableDecorative(state, x, y, z);
        }
        if (block instanceof BlockTripWireHook) {
            return new PlaceableDecorative(state, x, y, z);
        }
        return new PlaceableBlock(state, x, y, z);
    }

    public static PlaceableSign getFloorSignString(ITextComponent[] sign, IBlockState state, BlockPos pos) {
        return new PlaceableSign(state, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), sign);
    }

    public static PlaceableSign getWallSignString(ITextComponent[] sign, IBlockState state, BlockPos pos) {
        return new PlaceableSign(state, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), sign);
    }

    public static Placeable getPlaceableBlockString(World world, IBlockState state, int x, int y, int z) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150436_aH) {
            return new PlaceableDecorative(state, x, y, z);
        }
        if (block == Blocks.field_150414_aQ) {
            return new PlaceableDecorative(state, x, y, z);
        }
        return PlaceableHelper.getPrefixString(world, state, x, y, z);
    }

    public static Placeable getPlaceableEntityString(Entity entity, int x, int y, int z) {
        return entities.get(entity.getClass().getSimpleName()).getCopyFromEntity(entity, x, y, z);
    }

    static {
        entities.put("EntityItemFrame", new PlaceableItemFrame());
        entities.put("EntityPainting", new PlaceablePainting());
        entities.put("EntityNPC", new PlaceableNPC());
        entities.put("EntityNPCBuilder", new PlaceableNPC());
        entities.put("EntityNPCMiner", new PlaceableNPC());
        entities.put("EntityNPCShopkeeper", new PlaceableNPC());
    }
}

