/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings.placeable;

import joshie.harvest.core.util.Direction;
import net.minecraft.block.BlockBush;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class Placeable {
    protected int x;
    protected int y;
    protected int z;

    public Placeable init() {
        return this;
    }

    public BlockPos getOffsetPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean canPlace(ConstructionStage stage) {
        return stage == ConstructionStage.BUILD;
    }

    private void clearBushes(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockBush) {
            world.func_175698_g(pos);
            world.func_175685_c(pos, Blocks.field_150350_a);
        }
    }

    public boolean place(World world, BlockPos pos, Direction direction, ConstructionStage stage, boolean playSound) {
        if (world.func_180495_p(pos).func_185887_b(world, pos) == -1.0f) {
            return true;
        }
        if (this.canPlace(stage)) {
            BlockPos transformed = this.getTransformedPosition(pos, direction);
            if (stage == ConstructionStage.BUILD) {
                this.clearBushes(world, transformed.func_177984_a());
            }
            return this.place(world, transformed, direction, playSound);
        }
        return false;
    }

    public BlockPos getTransformedPosition(BlockPos pos, Direction direction) {
        BlockPos adjusted = this.transformBlockPos(direction);
        return new BlockPos(pos.func_177958_n() + adjusted.func_177958_n(), pos.func_177956_o() + adjusted.func_177956_o(), pos.func_177952_p() + adjusted.func_177952_p());
    }

    public BlockPos transformBlockPos(Direction direction) {
        int i = this.getX();
        int j = this.getY();
        int k = this.getZ();
        boolean flag = true;
        switch (direction.getMirror()) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (direction.getRotation()) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(k, j, -i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-k, j, i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-i, j, -k);
            }
        }
        return flag ? new BlockPos(i, j, k) : this.getOffsetPos();
    }

    public boolean place(World world, BlockPos pos, Direction direction, boolean playSound) {
        return false;
    }

    public static enum ConstructionStage {
        BUILD,
        PAINT,
        DECORATE,
        MOVEIN,
        FINISHED;

    }
}

