/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings.loader;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.buildings.placeable.blocks.PlaceableBlock;

public class PlaceableAdapter
implements JsonSerializer<Placeable>,
JsonDeserializer<Placeable> {
    public JsonElement serialize(Placeable src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        result.add("type", (JsonElement)new JsonPrimitive(src.getClass().getSimpleName()));
        result.add("isBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(src instanceof PlaceableBlock)));
        result.add("theData", context.serialize((Object)src, src.getClass()));
        return result;
    }

    public Placeable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String type = jsonObject.get("type").getAsString();
        String clazz = "";
        boolean isBlock = jsonObject.get("isBlock").getAsBoolean();
        if (type != null) {
            clazz = "joshie.harvest.buildings.placeable." + (isBlock ? "blocks." : "entities.") + type;
        }
        try {
            Placeable placeable = (Placeable)context.deserialize(jsonObject.get("theData"), Class.forName(clazz));
            if (placeable == null) {
                throw new NullPointerException(clazz);
            }
            placeable.init();
            return placeable;
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }
}

