/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings.loader;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.buildings.placeable.PlaceableHelper;
import joshie.harvest.buildings.placeable.blocks.PlaceableBlock;
import joshie.harvest.buildings.placeable.blocks.PlaceableChest;
import joshie.harvest.buildings.placeable.entities.PlaceableNPC;
import joshie.harvest.npc.NPC;
import joshie.harvest.npc.NPCRegistry;
import joshie.harvest.npc.entity.EntityNPCBuilder;
import joshie.harvest.npc.entity.EntityNPCShopkeeper;
import joshie.harvest.npc.entity.EntityNPCVillager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CodeGeneratorBuildings {
    private World world;
    private int x1;
    private int y1;
    private int z1;
    private int x2;
    private int y2;
    private int z2;

    public CodeGeneratorBuildings(World world, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd) {
        this.world = world;
        this.x1 = xStart < xEnd ? xStart : xEnd;
        this.x2 = xStart < xEnd ? xEnd : xStart;
        this.y1 = yStart < yEnd ? yStart : yEnd;
        this.y2 = yStart < yEnd ? yEnd : yStart;
        this.z1 = zStart < zEnd ? zStart : zEnd;
        this.z2 = zStart < zEnd ? zEnd : zStart;
    }

    public ArrayList<Entity> getEntities(Class clazz, int x, int y, int z) {
        return (ArrayList)this.world.func_72872_a(clazz, new AxisAlignedBB(new BlockPos(x, y, z)));
    }

    private void buildList(ArrayList<Placeable> ret, int x, int y, int z, Set<Entity> all) {
        TileEntityChest chest;
        HashSet<Entity> entityList = new HashSet<Entity>();
        entityList.addAll(this.getEntities(EntityPainting.class, this.x1 + x, this.y1 + y, this.z1 + z));
        entityList.addAll(this.getEntities(EntityItemFrame.class, this.x1 + x, this.y1 + y, this.z1 + z));
        entityList.addAll(this.getEntities(EntityNPCVillager.class, this.x1 + x, this.y1 + y, this.z1 + z));
        entityList.addAll(this.getEntities(EntityNPCBuilder.class, this.x1 + x, this.y1 + y, this.z1 + z));
        entityList.addAll(this.getEntities(EntityNPCShopkeeper.class, this.x1 + x, this.y1 + y, this.z1 + z));
        BlockPos position = new BlockPos(this.x1 + x, this.y1 + y, this.z1 + z);
        IBlockState state = this.world.func_180495_p(position);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150486_ae && (chest = (TileEntityChest)this.world.func_175625_s(new BlockPos(this.x1 + x, this.y1 + y, this.z1 + z))) != null) {
            String name = chest.func_70005_c_();
            if (name.startsWith("npc.")) {
                NPC npc = (NPC)NPCRegistry.REGISTRY.getValue(new ResourceLocation("harvestfestival", name = name.replace("npc.", "")));
                String npcField = npc == null ? "" : npc.getRegistryName().toString();
                ret.add(new PlaceableNPC(name, npcField, x, y, z));
                ret.add(new PlaceableBlock(Blocks.field_150350_a.func_176223_P(), x, y, z));
                return;
            }
            if (name.startsWith("loot.")) {
                ret.add(new PlaceableChest(name.replace("loot.", "chests/"), state, x, y, z));
                return;
            }
        }
        if ((block != Blocks.field_150350_a || entityList.size() > 0) && block != Blocks.field_150377_bs) {
            Object text;
            int meta = state.func_177230_c().func_176201_c(state);
            if ((block == Blocks.field_150398_cm || block instanceof BlockDoor) && meta >= 8) {
                return;
            }
            TileEntity tile = this.world.func_175625_s(position);
            if (tile instanceof TileEntitySign) {
                text = ((TileEntitySign)tile).field_145915_a;
                if (block == Blocks.field_150472_an) {
                    ret.add(PlaceableHelper.getFloorSignString(text, state, new BlockPos(x, y, z)));
                } else {
                    ret.add(PlaceableHelper.getWallSignString(text, state, new BlockPos(x, y, z)));
                }
            } else {
                text = PlaceableHelper.getPlaceableBlockString(this.world, state, x, y, z);
                ret.add((Placeable)text);
            }
            if (entityList.size() > 0) {
                for (Entity e : entityList) {
                    if (all.contains(e)) continue;
                    ret.add(PlaceableHelper.getPlaceableEntityString(e, x, y, z));
                    all.add(e);
                }
            }
        }
    }

    public void getCode() {
        if (!this.world.field_72995_K) {
            ArrayList<Placeable> ret = new ArrayList<Placeable>();
            HashSet<Entity> all = new HashSet<Entity>();
            for (int y = 0; y <= this.y2 - this.y1; ++y) {
                for (int x = 0; x <= this.x2 - this.x1; ++x) {
                    int z;
                    if (x % 2 == 0) {
                        for (z = 0; z <= this.z2 - this.z1; ++z) {
                            this.buildList(ret, x, y, z, all);
                        }
                        continue;
                    }
                    for (z = this.z2 - this.z1; z >= 0; --z) {
                        this.buildList(ret, x, y, z, all);
                    }
                }
            }
            BuildingImpl building = new BuildingImpl();
            building.components = new Placeable[ret.size()];
            for (int j = 0; j < ret.size(); ++j) {
                building.components[j] = (Placeable)ret.get(j);
            }
            try {
                String json = HFBuildings.getGson().toJson((Object)building);
                PrintWriter writer = new PrintWriter("building.json", "UTF-8");
                writer.write(json);
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

