/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings.item;

import joshie.harvest.buildings.BuildingHelper;
import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.BuildingRegistry;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.buildings.render.RenderKey;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.item.ItemHFFML;
import joshie.harvest.core.helpers.ChatHelper;
import joshie.harvest.core.util.ICreativeSorted;
import joshie.harvest.core.util.Text;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemBuilding
extends ItemHFFML<ItemBuilding, BuildingImpl>
implements ICreativeSorted {
    public ItemBuilding() {
        super(BuildingRegistry.REGISTRY, HFTab.TOWN);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_73011_w.getDimension() == 0) {
            RayTraceResult raytrace = BuildingHelper.rayTrace(player, 128.0, 0.0f);
            if (raytrace == null || raytrace.func_178782_a() == null) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            BuildingImpl building = (BuildingImpl)this.getObjectFromStack(stack);
            if (building != null && (HFCore.DEBUG_MODE || building.canHaveMultiple() || !((TownData)TownHelper.getClosestTownToEntity((EntityLivingBase)player)).hasBuilding(building.getRegistryName()))) {
                if (player.func_175151_a(raytrace.func_178782_a(), EnumFacing.DOWN, stack)) {
                    RenderKey key;
                    if (!world.field_72995_K) {
                        TownHelper.ensureTownExists(world, raytrace.func_178782_a());
                    }
                    if ((key = BuildingHelper.getPositioning(stack, world, raytrace, building, player, true)) != null) {
                        stack.func_77979_a(1);
                        return new ActionResult(building.generate(world, key.getPos(), key.getMirror(), key.getRotation()), (Object)stack);
                    }
                } else if (world.field_72995_K) {
                    ChatHelper.displayChat(TextFormatting.RED + Text.translate("town.failure") + " " + TextFormatting.WHITE + Text.translate("town.permission"));
                }
            } else if (world.field_72995_K) {
                ChatHelper.displayChat(TextFormatting.RED + Text.translate("town.failure") + " " + TextFormatting.WHITE + Text.translate("town.distance"));
            }
        } else if (world.field_72995_K) {
            ChatHelper.displayChat(TextFormatting.RED + Text.translate("town.failure") + " " + TextFormatting.WHITE + Text.translate("town.dimension"));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Override
    public BuildingImpl getNullValue() {
        return HFBuildings.null_building;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return Text.format("harvestfestival.structures.spawn", ((BuildingImpl)this.getObjectFromStack(stack)).getLocalisedName());
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 200;
    }
}

