/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings.item;

import joshie.harvest.buildings.BuildingHelper;
import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.BuildingRegistry;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.buildings.render.RenderKey;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.item.ItemHFFML;
import joshie.harvest.core.helpers.ChatHelper;
import joshie.harvest.core.util.Direction;
import joshie.harvest.core.util.ICreativeSorted;
import joshie.harvest.core.util.Text;
import joshie.harvest.npc.entity.EntityNPCBuilder;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownDataServer;
import joshie.harvest.town.TownHelper;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlueprint
extends ItemHFFML<ItemBlueprint, BuildingImpl>
implements ICreativeSorted {
    public ItemBlueprint() {
        super(BuildingRegistry.REGISTRY, HFTab.TOWN);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_73011_w.getDimension() == 0) {
            RayTraceResult raytrace = BuildingHelper.rayTrace(player, 128.0, 0.0f);
            if (raytrace == null || raytrace.func_178782_a() == null) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            BuildingImpl building = (BuildingImpl)this.getObjectFromStack(stack);
            Object town = TownHelper.getClosestTownToEntity((EntityLivingBase)player);
            if (player.func_175151_a(raytrace.func_178782_a(), EnumFacing.DOWN, stack)) {
                if (!world.field_72995_K) {
                    TownHelper.ensureTownExists(world, raytrace.func_178782_a());
                }
                if (building != null && (HFCore.DEBUG_MODE || building.canHaveMultiple() || !((TownData)town).hasBuilding(building.getRegistryName()) && !((TownData)town).isBuilding(building))) {
                    RenderKey key = BuildingHelper.getPositioning(stack, world, raytrace, building, player, true);
                    if (key != null) {
                        if (!((TownData)TownHelper.getClosestTownToBlockPos(world, key.getPos())).isBuilding(building)) {
                            if (!world.field_72995_K) {
                                Direction direction = Direction.withMirrorAndRotation(key.getMirror(), key.getRotation());
                                EntityNPCBuilder builder = ((TownDataServer)TownHelper.getClosestTownToEntity((EntityLivingBase)player)).getBuilder((WorldServer)world);
                                BlockPos pos = key.getPos();
                                if (builder != null && !((TownData)TownHelper.getClosestTownToEntity((EntityLivingBase)player)).hasBuilding(building.getRegistryName()) && ((TownDataServer)TownHelper.getClosestTownToBlockPos(world, pos)).setBuilding(world, building, pos.func_177979_c(building.getOffsetY()), direction.getMirror(), direction.getRotation()) && builder.getBuilding() == null) {
                                    builder.func_70107_b(pos.func_177958_n(), pos.func_177984_a().func_177956_o(), pos.func_177952_p());
                                }
                            }
                            stack.func_77979_a(1);
                            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                        }
                        if (world.field_72995_K) {
                            ChatHelper.displayChat(TextFormatting.RED + Text.translate("town.failure") + " " + TextFormatting.WHITE + Text.translate("town.building"));
                        }
                    }
                } else if (world.field_72995_K) {
                    ChatHelper.displayChat(TextFormatting.RED + Text.translate("town.failure") + " " + TextFormatting.WHITE + Text.translate("town.permission"));
                }
            } else if (world.field_72995_K) {
                ChatHelper.displayChat(TextFormatting.RED + Text.translate("town.failure") + " " + TextFormatting.WHITE + Text.translate("town.distance"));
            }
        } else if (world.field_72995_K) {
            ChatHelper.displayChat(TextFormatting.RED + Text.translate("town.failure") + " " + TextFormatting.WHITE + Text.translate("town.dimension"));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Override
    public BuildingImpl getNullValue() {
        return HFBuildings.null_building;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return Text.format("harvestfestival.structures.blueprint", ((BuildingImpl)this.getObjectFromStack(stack)).getLocalisedName());
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 105;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        for (BuildingImpl building : this.registry) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)this.registry.getValues().indexOf(building), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }
}

