/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings.block;

import java.util.List;
import javax.annotation.Nullable;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.buildings.item.ItemCheat;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFBase;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.core.util.Text;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInternalAir
extends BlockHFBase<BlockInternalAir> {
    public BlockInternalAir() {
        super(Material.field_151592_s, HFTab.TOWN);
    }

    @Override
    public String getItemStackDisplayName(ItemStack stack) {
        return Text.localizeFully(this.func_149739_a());
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176214_u() {
        return false;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (HFCore.DEBUG_MODE) {
            list.add(new ItemStack(itemIn));
        }
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 999;
    }

    public static void onPlaced(World world, BlockPos pos, EntityPlayer player) {
        MinecraftForge.EVENT_BUS.register((Object)new RemoveIfHolding(world, pos, player));
    }

    private static class RemoveIfHolding {
        private final World world;
        private final BlockPos pos;
        private final EntityPlayer player;

        RemoveIfHolding(World world, BlockPos pos, EntityPlayer player) {
            this.world = world;
            this.pos = pos;
            this.player = player;
        }

        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.player == this.player && event.phase == TickEvent.Phase.END && InventoryHelper.getHandItemIsIn(event.player, InventoryHelper.ITEM_STACK, HFBuildings.CHEAT.getStackFromEnum(ItemCheat.Cheat.AIR_REMOVER), new int[0]) != null) {
                this.world.func_175698_g(this.pos);
                try {
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

