/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import joshie.harvest.HarvestFestival;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.buildings.Building;
import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.BuildingRegistry;
import joshie.harvest.buildings.ResourceLoader;
import joshie.harvest.buildings.block.BlockInternalAir;
import joshie.harvest.buildings.item.ItemBlueprint;
import joshie.harvest.buildings.item.ItemBuilding;
import joshie.harvest.buildings.item.ItemCheat;
import joshie.harvest.buildings.loader.PlaceableAdapter;
import joshie.harvest.buildings.loader.ResourceAdapter;
import joshie.harvest.buildings.loader.StackAdapter;
import joshie.harvest.buildings.loader.StateAdapter;
import joshie.harvest.buildings.loader.TextComponentAdapter;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.core.base.FMLDefinition;
import joshie.harvest.core.base.MeshIdentical;
import joshie.harvest.core.helpers.ConfigHelper;
import joshie.harvest.core.util.HFLoader;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@HFLoader(priority=4)
public class HFBuildings {
    public static final ItemBuilding STRUCTURES = (ItemBuilding)new ItemBuilding().register("structures");
    public static final ItemBlueprint BLUEPRINTS = (ItemBlueprint)new ItemBlueprint().register("blueprint");
    public static final ItemCheat CHEAT = (ItemCheat)new ItemCheat().register("cheat");
    public static final BlockInternalAir AIR = (BlockInternalAir)((Object)new BlockInternalAir().register("air"));
    public static final BuildingImpl null_building = new BuildingImpl();
    public static final Building BARN = HFBuildings.registerBuilding("barn", 6000L, 100, 0).setRequirements("carpenter").setOffset(6, -1, 8);
    public static final Building BLACKSMITH = HFBuildings.registerBuilding("blacksmith", 7000L, 16, 160).setRequirements("supermarket", "barn", "poultryFarm").setOffset(3, -2, 6);
    public static final Building CAFE = HFBuildings.registerBuilding("cafe", 16000L, 200, 110).setRequirements("miningHill", "goddessPond").setOffset(7, -1, 10);
    public static final Building CARPENTER = HFBuildings.registerBuilding("carpenter", 0L, 0, 0).setSpecialRules((w, p) -> false).setOffset(3, -1, 8);
    public static final Building CHURCH = HFBuildings.registerBuilding("church", 20000L, 160, 128).setRequirements("miningHill", "goddessPond").setOffset(6, -1, 13);
    public static final Building CLOCKMAKER = HFBuildings.registerBuilding("clockmaker", 9600L, 120, 78).setRequirements("miningHill", "goddessPond").setOffset(3, -1, 10);
    public static final Building FISHING_HOLE = HFBuildings.registerBuilding("fishingHole", 3000L, 16, 0).setRequirements("fishingHut").setOffset(6, -4, 7);
    public static final Building FISHING_HUT = HFBuildings.registerBuilding("fishingHut", 12000L, 64, 0).setRequirements("miningHill", "goddessPond").setOffset(4, -1, 10);
    public static final Building GODDESS_POND = HFBuildings.registerBuilding("goddessPond", 500L, 16, 0).setRequirements("blacksmith").setOffset(11, -1, 20);
    public static final Building MINING_HILL = HFBuildings.registerBuilding("miningHill", 2000L, 0, 32).setRequirements("miningHut").setOffset(10, -3, 11);
    public static final Building MINING_HUT = HFBuildings.registerBuilding("miningHut", 6000L, 64, 64).setRequirements("supermarket", "barn", "poultryFarm").setOffset(10, -1, 10);
    public static final Building POULTRY_FARM = HFBuildings.registerBuilding("poultryFarm", 4000L, 100, 0).setRequirements("carpenter").setOffset(4, -1, 12);
    public static final Building SUPERMARKET = HFBuildings.registerBuilding("supermarket", 3000L, 192, 64).setRequirements("carpenter").setOffset(7, -10, 12).setTickTime(5L);
    public static final Building TOWNHALL = HFBuildings.registerBuilding("townhall", 32000L, 640, 256).setRequirements("blacksmith", "miningHill", "goddessPond").setOffset(10, -1, 17);
    private static Gson gson;
    public static boolean FULL_BUILDING_RENDER;
    public static boolean CHEAT_BUILDINGS;

    public static void preInit() {
        HarvestFestival.LOGGER.log(Level.INFO, "Creating Harvest Festival Buildings!");
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInitClient() {
        ModelLoader.setCustomMeshDefinition((Item)STRUCTURES, new FMLDefinition<BuildingImpl>(STRUCTURES, "buildings", BuildingRegistry.REGISTRY));
        ModelLoader.setCustomMeshDefinition((Item)BLUEPRINTS, (ItemMeshDefinition)new MeshIdentical(BLUEPRINTS));
    }

    public static void init() {
        HFApi.npc.getGifts().addToBlacklist(STRUCTURES, BLUEPRINTS);
        for (BuildingImpl building : BuildingRegistry.REGISTRY.getValues()) {
            building.initBuilding(HFBuildings.getBuilding(building.getRegistryName()));
        }
        gson = null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        FMLDefinition.getDefinition("buildings").registerEverything();
    }

    private static Building registerBuilding(String building, long cost, int wood, int stone) {
        return HFApi.buildings.registerBuilding(new ResourceLocation("harvestfestival", building), cost, wood, stone);
    }

    private static BuildingImpl getBuilding(ResourceLocation resource) {
        return (BuildingImpl)HFBuildings.getGson().fromJson(ResourceLoader.getJSONResource(resource, "buildings"), BuildingImpl.class);
    }

    public static Gson getGson() {
        if (gson == null) {
            GsonBuilder builder = new GsonBuilder().setPrettyPrinting().setExclusionStrategies(new ExclusionStrategy[]{new SuperClassExclusionStrategy()});
            builder.registerTypeAdapter(Placeable.class, (Object)new PlaceableAdapter());
            builder.registerTypeAdapter(IBlockState.class, (Object)new StateAdapter());
            builder.registerTypeAdapter(ItemStack.class, (Object)new StackAdapter());
            builder.registerTypeAdapter(ResourceLocation.class, (Object)new ResourceAdapter());
            builder.registerTypeAdapter(TextComponentString.class, (Object)new TextComponentAdapter());
            gson = builder.create();
        }
        return gson;
    }

    public static void configure() {
        FULL_BUILDING_RENDER = ConfigHelper.getBoolean("Use Full Building Render", true);
        CHEAT_BUILDINGS = ConfigHelper.getBoolean("Use Cheat Buildings", false);
    }

    private static class SuperClassExclusionStrategy
    implements ExclusionStrategy {
        private SuperClassExclusionStrategy() {
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes field) {
            return field.getDeclaringClass().equals(IForgeRegistryEntry.Impl.class);
        }
    }
}

