/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings;

import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.BuildingRegistry;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.util.Direction;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownDataServer;
import joshie.harvest.town.TownHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BuildingStage {
    public BuildingImpl building;
    public Direction direction;
    public Placeable.ConstructionStage stage;
    public boolean basement;
    public int index;
    public BlockPos pos;

    public BuildingStage() {
    }

    public BuildingStage(BuildingImpl building, BlockPos pos, Mirror mirror, Rotation rotation) {
        this.building = building;
        this.direction = Direction.withMirrorAndRotation(mirror, rotation);
        this.stage = Placeable.ConstructionStage.BUILD;
        this.index = 0;
        this.basement = true;
        this.pos = pos.func_177982_a(0, building.getOffsetY(), 0);
    }

    public Placeable next() {
        return this.index < this.building.getFullList().size() ? this.building.getFullList().get(this.index) : null;
    }

    public Placeable previous() {
        int position = this.index - 1;
        return position >= 0 && position < this.building.getFullList().size() ? this.building.getFullList().get(position) : null;
    }

    public BuildingImpl getBuilding() {
        return this.building;
    }

    public Placeable.ConstructionStage getStage() {
        return this.stage;
    }

    public BlockPos getPos(Placeable placeable) {
        if (placeable == null) {
            return this.next().getTransformedPosition(this.pos, this.direction);
        }
        return placeable.getTransformedPosition(this.pos, this.direction);
    }

    public double getDistance(Placeable placeable) {
        return placeable.getOffsetPos().func_177956_o() <= -this.building.getOffsetY() ? 256.0 : 96.0;
    }

    private boolean increaseIndex(World world) {
        Placeable placeable;
        ++this.index;
        if (this.index >= this.building.getFullList().size()) {
            if (this.stage == Placeable.ConstructionStage.BUILD) {
                this.stage = Placeable.ConstructionStage.DECORATE;
                this.index = 0;
            } else if (this.stage == Placeable.ConstructionStage.DECORATE) {
                this.stage = Placeable.ConstructionStage.PAINT;
                this.index = 0;
            } else if (this.stage == Placeable.ConstructionStage.PAINT) {
                this.stage = Placeable.ConstructionStage.MOVEIN;
                this.index = 0;
            } else if (this.stage == Placeable.ConstructionStage.MOVEIN) {
                this.stage = Placeable.ConstructionStage.FINISHED;
                this.index = 0;
                this.basement = true;
                ((TownData)TownHelper.getClosestTownToBlockPos(world, this.pos)).addBuilding(world, this.building, this.direction, this.pos);
                ((TownDataServer)TownHelper.getClosestTownToBlockPos(world, this.pos)).syncBuildings(world);
                return true;
            }
            ((TownDataServer)TownHelper.getClosestTownToBlockPos(world, this.pos)).syncBuildings(world);
        }
        if (this.basement && (placeable = this.next()).getOffsetPos().func_177956_o() > -this.getBuilding().getOffsetY()) {
            this.basement = false;
            HFTrackers.markDirty(world);
            ((TownDataServer)TownHelper.getClosestTownToBlockPos(world, this.pos)).syncBuildings(world);
        }
        return true;
    }

    public boolean build(World world) {
        while (this.index < this.building.getFullList().size()) {
            Placeable block = this.building.getFullList().get(this.index);
            if (block.place(world, this.pos, this.direction, this.stage, true)) {
                return this.increaseIndex(world);
            }
            this.increaseIndex(world);
            if (!this.isFinished()) continue;
            return true;
        }
        return this.isFinished() || this.increaseIndex(world);
    }

    public long getTickTime() {
        return this.building.getTickTime();
    }

    public boolean isFinished() {
        return this.stage == Placeable.ConstructionStage.FINISHED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildingStage that = (BuildingStage)o;
        return this.building != null ? this.building.equals(that.building) : that.building == null;
    }

    public int hashCode() {
        return this.building != null ? this.building.hashCode() : 0;
    }

    public static BuildingStage readFromNBT(NBTTagCompound nbt) {
        BuildingStage stage = new BuildingStage();
        stage.building = (BuildingImpl)BuildingRegistry.REGISTRY.getValue(new ResourceLocation(nbt.func_74779_i("CurrentlyBuilding")));
        stage.direction = Direction.valueOf(nbt.func_74779_i("Direction"));
        stage.pos = new BlockPos(nbt.func_74762_e("BuildingX"), nbt.func_74762_e("BuildingY"), nbt.func_74762_e("BuildingZ"));
        stage.basement = nbt.func_74767_n("Basement");
        if (nbt.func_74764_b("Stage")) {
            stage.index = nbt.func_74762_e("Index");
            stage.stage = Placeable.ConstructionStage.values()[nbt.func_74762_e("Stage")];
        }
        return stage;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("CurrentlyBuilding", BuildingRegistry.REGISTRY.getKey((IForgeRegistryEntry)this.building).toString());
        nbt.func_74778_a("Direction", this.direction.name());
        nbt.func_74768_a("BuildingX", this.pos.func_177958_n());
        nbt.func_74768_a("BuildingY", this.pos.func_177956_o());
        nbt.func_74768_a("BuildingZ", this.pos.func_177952_p());
        nbt.func_74757_a("Basement", this.basement);
        if (this.stage != null) {
            nbt.func_74768_a("Stage", this.stage.ordinal());
            nbt.func_74768_a("Index", this.index);
        }
    }
}

