/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import joshie.harvest.api.buildings.IBuilding;
import joshie.harvest.api.buildings.IBuildingProvider;
import joshie.harvest.blocks.BlockPreview;
import joshie.harvest.blocks.HFBlocks;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.buildings.placeable.blocks.PlaceableBlock;
import joshie.harvest.buildings.placeable.entities.PlaceableNPC;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BuildingProvider
implements IBuildingProvider {
    public HashMap<String, PlaceableNPC> npc_offsets = new HashMap();
    protected ArrayList<PlaceableBlock> block_list = new ArrayList();
    protected ArrayList<Placeable> full_list;
    private IBuilding building;

    @Override
    public void setBuilding(IBuilding building) {
        this.building = building;
    }

    public void setList(ArrayList<Placeable> list) {
        this.full_list = list;
    }

    public void setList(Placeable[] list) {
        this.full_list = new ArrayList();
        Collections.addAll(this.full_list, list);
    }

    public void addToList(Placeable placeable) {
        PlaceableNPC npc;
        String home;
        PlaceableBlock block;
        if (placeable instanceof PlaceableBlock && (block = (PlaceableBlock)placeable).getBlock() != Blocks.field_150350_a) {
            this.block_list.add((PlaceableBlock)placeable);
        }
        if (placeable instanceof PlaceableNPC && (home = (npc = (PlaceableNPC)placeable).getHomeString()) != null) {
            this.npc_offsets.put(home, npc);
        }
    }

    @Override
    public IBuilding getBuilding() {
        return this.building;
    }

    @Override
    public ItemStack getPreview() {
        return HFBlocks.PREVIEW.getItemStack(this.building);
    }

    @Override
    public PlaceableNPC getNPCOffset(String npc_location) {
        return this.npc_offsets.get(npc_location);
    }

    @Override
    public int getSize() {
        return this.full_list.size();
    }

    @Override
    public List<PlaceableBlock> getPreviewList() {
        return this.block_list;
    }

    @Override
    public List<Placeable> getFullList() {
        return this.full_list;
    }

    @Override
    public EnumActionResult generate(UUID uuid, World world, BlockPos pos) {
        if (!world.field_72995_K && this.full_list != null) {
            BlockPreview.Direction direction = BlockPreview.Direction.values()[world.field_73012_v.nextInt(BlockPreview.Direction.values().length)];
            for (Placeable placeable : this.full_list) {
                placeable.place(uuid, world, pos, direction, Placeable.ConstructionStage.BUILD);
            }
            for (Placeable placeable : this.full_list) {
                placeable.place(uuid, world, pos, direction, Placeable.ConstructionStage.PAINT);
            }
            for (Placeable placeable : this.full_list) {
                placeable.place(uuid, world, pos, direction, Placeable.ConstructionStage.DECORATE);
            }
            for (Placeable placeable : this.full_list) {
                placeable.place(uuid, world, pos, direction, Placeable.ConstructionStage.MOVEIN);
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

