/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import joshie.harvest.api.buildings.Building;
import joshie.harvest.api.buildings.ISpecialPurchaseRules;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.buildings.placeable.blocks.PlaceableBlock;
import joshie.harvest.buildings.placeable.blocks.PlaceableDecorative;
import joshie.harvest.buildings.placeable.entities.PlaceableNPC;
import joshie.harvest.core.helpers.MCServerHelper;
import joshie.harvest.core.util.Direction;
import joshie.harvest.town.TownData;
import joshie.harvest.town.TownHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockWall;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BuildingImpl
extends IForgeRegistryEntry.Impl<BuildingImpl>
implements Building {
    private final transient HashMap<String, PlaceableNPC> npc_offsets = new HashMap();
    private final transient ArrayList<PlaceableBlock> block_list = new ArrayList();
    private transient ArrayList<Placeable> full_list = new ArrayList();
    private transient ISpecialPurchaseRules special = (w, p) -> true;
    private transient String toLocalise = "";
    private transient ResourceLocation[] requirements = new ResourceLocation[0];
    private transient long cost = 1000L;
    private transient int wood = 64;
    private transient int stone = 64;
    private transient int offsetY = -1;
    private transient long tickTime = 15L;
    private transient int width;
    private transient int length;
    private transient boolean canHaveMultiple;
    private transient boolean isPurchaseable = true;
    public Placeable[] components;

    public BuildingImpl setCosts(long cost, int wood, int stone) {
        this.cost = cost;
        this.wood = wood;
        this.stone = stone;
        return this;
    }

    public void initBuilding(BuildingImpl building) {
        this.full_list = new ArrayList();
        Collections.addAll(this.full_list, building.components);
        for (Placeable placeable : this.full_list) {
            this.addToList(placeable);
        }
        if (this.getRegistryName() != null) {
            this.toLocalise = this.getRegistryName().func_110624_b().toLowerCase(Locale.ENGLISH) + ".structures." + this.getRegistryName().func_110623_a().toLowerCase(Locale.ENGLISH);
        }
        this.components = null;
    }

    private boolean isValidBlock(Block block) {
        return block.func_149686_d(block.func_176223_P()) || block instanceof BlockStairs || block instanceof BlockSlab || block instanceof BlockPane || block instanceof BlockLeaves || block instanceof BlockFence || block instanceof BlockWall;
    }

    public void addToList(Placeable placeable) {
        PlaceableNPC npc;
        String home;
        PlaceableBlock block;
        if (placeable instanceof PlaceableBlock && (block = (PlaceableBlock)placeable).getOffsetPos().func_177956_o() >= -this.getOffsetY() && block.getBlock() != Blocks.field_150350_a && !(block instanceof PlaceableDecorative) && this.isValidBlock(block.getBlock())) {
            this.block_list.add((PlaceableBlock)placeable);
        }
        if (placeable instanceof PlaceableNPC && (home = (npc = (PlaceableNPC)placeable).getHomeString()) != null) {
            this.npc_offsets.put(home, npc);
        }
    }

    private ResourceLocation getResourceFromName(String resource) {
        if (resource.contains(":")) {
            return new ResourceLocation(resource);
        }
        return new ResourceLocation("harvestfestival", resource);
    }

    @Override
    public Building setRequirements(String ... requirements) {
        this.requirements = new ResourceLocation[requirements.length];
        for (int i = 0; i < requirements.length; ++i) {
            this.requirements[i] = this.getResourceFromName(requirements[i]);
        }
        return this;
    }

    @Override
    public Building setTickTime(long time) {
        this.tickTime = time;
        return this;
    }

    @Override
    public Building setOffset(int width, int offsetY, int length) {
        this.width = width;
        this.offsetY = offsetY;
        this.length = length;
        return this;
    }

    @Override
    public Building setSpecialRules(ISpecialPurchaseRules special) {
        this.special = special;
        return this;
    }

    @Override
    public Building setMultiple() {
        this.canHaveMultiple = true;
        return this;
    }

    @Override
    public Building setNoPurchase() {
        this.isPurchaseable = false;
        return this;
    }

    @Override
    public ISpecialPurchaseRules getRules() {
        return this.special;
    }

    @Override
    public String getLocalisedName() {
        return I18n.func_74838_a((String)this.toLocalise);
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public int getWoodCount() {
        return this.wood;
    }

    @Override
    public int getStoneCount() {
        return this.stone;
    }

    @Override
    public ItemStack getBlueprint() {
        return HFBuildings.BLUEPRINTS.getStackFromObject(this);
    }

    @Override
    public ItemStack getSpawner() {
        return HFBuildings.STRUCTURES.getStackFromObject(this);
    }

    @Override
    public EnumActionResult generate(World world, BlockPos pos, Mirror mirror, Rotation rotation) {
        if (!world.field_72995_K && this.full_list != null) {
            Direction direction = Direction.withMirrorAndRotation(mirror, rotation);
            for (Placeable placeable : this.full_list) {
                placeable.place(world, pos, direction, Placeable.ConstructionStage.BUILD, false);
            }
            for (Placeable placeable : this.full_list) {
                placeable.place(world, pos, direction, Placeable.ConstructionStage.DECORATE, false);
            }
            for (Placeable placeable : this.full_list) {
                placeable.place(world, pos, direction, Placeable.ConstructionStage.PAINT, false);
            }
            for (Placeable placeable : this.full_list) {
                placeable.place(world, pos, direction, Placeable.ConstructionStage.MOVEIN, false);
            }
            ((TownData)TownHelper.getClosestTownToBlockPos(world, pos)).addBuilding(world, this, direction, pos);
            MCServerHelper.markForUpdate(world, pos);
        }
        return EnumActionResult.SUCCESS;
    }

    public List<Placeable> getFullList() {
        return this.full_list;
    }

    public List<PlaceableBlock> getPreviewList() {
        return this.block_list;
    }

    public PlaceableNPC getNPCOffset(String npc_location) {
        return this.npc_offsets.get(npc_location);
    }

    public long getTickTime() {
        return this.tickTime;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public boolean hasRequirements(EntityPlayer player) {
        return ((TownData)TownHelper.getClosestTownToEntity((EntityLivingBase)player)).hasBuildings(this.requirements);
    }

    public int getLength() {
        return this.length;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean canPurchase() {
        return this.isPurchaseable;
    }

    public boolean canHaveMultiple() {
        return this.canHaveMultiple;
    }

    public boolean equals(Object o) {
        return o instanceof BuildingImpl && this.getRegistryName() != null && this.getRegistryName().equals((Object)((BuildingImpl)o).getRegistryName());
    }

    public int hashCode() {
        return this.getRegistryName() == null ? 0 : this.getRegistryName().hashCode();
    }
}

