/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings;

import java.util.WeakHashMap;
import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.render.RenderKey;
import joshie.harvest.core.helpers.ChatHelper;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.util.Text;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class BuildingHelper {
    private static final WeakHashMap<EntityPlayer, RenderKey> POSITIONS_SERVER = new WeakHashMap();
    private static final WeakHashMap<EntityPlayer, ItemStack> STACKS_SERVER = new WeakHashMap();
    private static RenderKey POSITION_CLIENT;
    private static ItemStack STACK_CLIENT;

    public static Vec3d getPositionEyes(EntityPlayer player, float partialTicks) {
        if (partialTicks == 1.0f) {
            return new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        }
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks + (double)player.func_70047_e();
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        return new Vec3d(d0, d1, d2);
    }

    public static RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = BuildingHelper.getPositionEyes(player, partialTicks);
        Vec3d vec3d1 = player.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    private static void validateOrInvalidateStack(ItemStack stack, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            if (STACK_CLIENT != stack) {
                STACK_CLIENT = stack;
                POSITION_CLIENT = null;
            }
        } else if (STACKS_SERVER.get(player) != stack) {
            STACKS_SERVER.put(player, stack);
            POSITIONS_SERVER.remove(player);
        }
    }

    private static void setPositionForPlayer(EntityPlayer player, RenderKey pos) {
        if (player.field_70170_p.field_72995_K) {
            POSITION_CLIENT = pos;
        } else {
            POSITIONS_SERVER.put(player, pos);
        }
    }

    private static RenderKey getPositionForPlayer(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return POSITION_CLIENT;
        }
        return POSITIONS_SERVER.get(player);
    }

    private static boolean isAir(World world, BlockPos pos) {
        return world.func_175623_d(pos);
    }

    private static RenderKey getCachedKey(EntityPlayer player, BlockPos pos, BuildingImpl building) {
        EnumFacing facing = EntityHelper.getFacingFromEntity((EntityLivingBase)player).func_176734_d();
        Mirror mirror = Mirror.NONE;
        Rotation rotation = Rotation.NONE;
        if (facing == EnumFacing.NORTH) {
            rotation = Rotation.CLOCKWISE_90;
        } else if (facing == EnumFacing.SOUTH) {
            rotation = Rotation.COUNTERCLOCKWISE_90;
        } else if (facing == EnumFacing.EAST) {
            rotation = Rotation.CLOCKWISE_180;
        } else if (facing == EnumFacing.WEST) {
            rotation = Rotation.NONE;
        }
        int length = building.getLength();
        int width = building.getWidth();
        if (facing == EnumFacing.NORTH) {
            pos = pos.func_177967_a(facing, length).func_177967_a(EnumFacing.EAST, width);
        } else if (facing == EnumFacing.SOUTH) {
            pos = pos.func_177967_a(facing, length).func_177967_a(EnumFacing.WEST, width);
        } else if (facing == EnumFacing.EAST) {
            pos = pos.func_177967_a(facing, length).func_177967_a(EnumFacing.SOUTH, width);
        } else if (facing == EnumFacing.WEST) {
            pos = pos.func_177967_a(facing, length).func_177967_a(EnumFacing.NORTH, width);
        }
        return RenderKey.of(mirror, rotation, building, pos);
    }

    public static RenderKey getPositioning(ItemStack stack, World world, RayTraceResult raytrace, BuildingImpl building, EntityPlayer player, boolean clicked) {
        BuildingHelper.validateOrInvalidateStack(stack, player);
        BlockPos pos = raytrace.func_178782_a().func_177972_a(raytrace.field_178784_b).func_177981_b(building.getOffsetY());
        RenderKey key = BuildingHelper.getPositionForPlayer(player);
        if (key == null) {
            if (clicked) {
                if (!BuildingHelper.isAir(world, raytrace.func_178782_a()) && raytrace.field_178784_b == EnumFacing.UP) {
                    BuildingHelper.setPositionForPlayer(player, BuildingHelper.getCachedKey(player, pos, building));
                    if (world.field_72995_K) {
                        ChatHelper.displayChat(TextFormatting.YELLOW + building.getLocalisedName() + TextFormatting.RESET + " " + Text.translate("town.preview") + "\n-" + Text.translate("town.sneak") + " " + TextFormatting.GREEN + "" + Text.translate("town.confirm") + "\n-" + TextFormatting.RESET + Text.translate("town.click") + " " + TextFormatting.RED + Text.translate("town.cancel"));
                    }
                }
                return null;
            }
        } else if (clicked) {
            if (!player.func_70093_af() && world.field_72995_K) {
                ChatHelper.displayChat(TextFormatting.RED + building.getLocalisedName() + " " + Text.translate("town.cancelled"));
            }
            BuildingHelper.setPositionForPlayer(player, null);
            return player.func_70093_af() ? key : null;
        }
        return key == null ? (raytrace.field_178784_b != EnumFacing.UP ? null : BuildingHelper.getCachedKey(player, pos, building)) : key;
    }
}

