/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings;

import joshie.harvest.api.buildings.IBuilding;
import joshie.harvest.api.buildings.IBuildingProvider;
import joshie.harvest.api.buildings.ISpecialPurchaseRules;
import joshie.harvest.buildings.SpecialRulesDefault;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.core.handlers.HFTrackers;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class Building
implements IBuilding {
    private transient ISpecialPurchaseRules special = new SpecialRulesDefault();
    private transient IBuildingProvider provider;
    private transient String toLocalise;
    public transient ResourceLocation resource;
    public ResourceLocation[] requirements;
    public long cost;
    public int wood;
    public int stone;
    public int offsetY;
    public long tickTime;
    public Placeable[] components;

    public Building() {
    }

    public Building(String string) {
        this.resource = new ResourceLocation("harvestfestival", string);
    }

    @Override
    public String getLocalisedName() {
        return I18n.func_74838_a((String)this.toLocalise);
    }

    @Override
    public ResourceLocation getResource() {
        return this.resource;
    }

    @Override
    public IBuilding setProvider(IBuildingProvider provider) {
        this.provider = provider;
        this.provider.setBuilding(this);
        this.toLocalise = this.resource.func_110624_b().toLowerCase() + ".structures." + this.resource.func_110623_a().toLowerCase();
        return this;
    }

    @Override
    public IBuildingProvider getProvider() {
        return this.provider;
    }

    @Override
    public long getTickTime() {
        return this.tickTime;
    }

    @Override
    public int getOffsetY() {
        return this.offsetY;
    }

    @Override
    public IBuilding setSpecialRules(ISpecialPurchaseRules special) {
        this.special = special;
        return this;
    }

    @Override
    public ISpecialPurchaseRules getRules() {
        return this.special;
    }

    @Override
    public boolean hasRequirements(EntityPlayer player) {
        return HFTrackers.getPlayerTracker((EntityPlayer)player).getTown().hasBuildings(this.requirements);
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public int getWoodCount() {
        return this.wood;
    }

    @Override
    public int getStoneCount() {
        return this.stone;
    }

    public boolean equals(Object o) {
        return o instanceof Building && this.resource != null && this.resource.equals((Object)((Building)o).resource);
    }

    public int hashCode() {
        return this.resource == null ? 0 : this.resource.hashCode();
    }
}

