/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.blocks.tiles;

import java.util.ArrayList;
import java.util.List;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.WorldLocation;
import joshie.harvest.api.buildings.IBuilding;
import joshie.harvest.blocks.BlockPreview;
import joshie.harvest.blocks.HFBlocks;
import joshie.harvest.buildings.placeable.blocks.PlaceableBlock;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.network.PacketSyncMarker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileMarker
extends TileEntity {
    private boolean needsInit = true;
    private List<PlaceableBlock> clone;
    private BlockPreview.Direction direction;
    private IBuilding building;

    public void setBuilding(IBuilding building) {
        this.direction = (BlockPreview.Direction)((Object)HFBlocks.PREVIEW.getEnumFromMeta(this.func_145832_p()));
        this.building = building;
        this.needsInit = true;
        this.func_70296_d();
    }

    public List<PlaceableBlock> getList() {
        if (this.needsInit) {
            this.clone = new ArrayList<PlaceableBlock>();
            for (PlaceableBlock block : this.building.getProvider().getPreviewList()) {
                this.clone.add(block.copyWithOffset(this.func_174877_v(), this.direction));
            }
        }
        return this.building.getProvider().getPreviewList();
    }

    public IBuilding getBuilding() {
        return this.building;
    }

    public IMessage getPacket() {
        return new PacketSyncMarker(new WorldLocation(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c), this.building);
    }

    public BlockPreview.Direction getDirection() {
        return this.direction;
    }

    public Packet<?> getDescriptionPacket() {
        return PacketHandler.getPacket((IMessage)this.getPacket());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.building = HFApi.BUILDINGS.getBuildingFromName(new ResourceLocation(nbt.func_74779_i("Building")));
        if (nbt.func_74764_b("Direction")) {
            this.direction = BlockPreview.Direction.valueOf(nbt.func_74779_i("Direction"));
        }
        this.needsInit = nbt.func_74767_n("Init");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("Init", this.needsInit);
        nbt.func_74778_a("Direction", this.direction.name());
        if (this.building != null) {
            nbt.func_74778_a("Building", this.building.getResource().toString());
        }
    }
}

