/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.blocks.tiles;

import java.util.ArrayList;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.cooking.IAltItem;
import joshie.harvest.api.cooking.IUtensil;
import joshie.harvest.blocks.tiles.TileFaceable;
import joshie.harvest.cooking.Utensil;
import joshie.harvest.core.helpers.generic.StackHelper;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.network.PacketSyncCooking;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class TileCooking
extends TileFaceable {
    public static short COOK_TIMER = (short)100;
    private boolean cooking;
    private short cookTimer = 0;
    private ArrayList<ItemStack> ingredients = new ArrayList();
    private ItemStack result;
    public float[] rotations = new float[20];
    public float[] offset1 = new float[20];
    public float[] offset2 = new float[20];
    public float[] heightOffset = new float[20];

    public abstract IUtensil getUtensil();

    public boolean isCooking() {
        return this.cooking;
    }

    public boolean hasPrerequisites() {
        return true;
    }

    public boolean canAddItems() {
        return this.result == null;
    }

    public ItemStack getResult() {
        return this.result != null ? this.result.func_77946_l() : this.result;
    }

    public ArrayList<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public void clear() {
        this.result = null;
    }

    public void animate() {
    }

    public short getCookingTime() {
        return COOK_TIMER;
    }

    public void update() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.cooking) {
                this.cookTimer = (short)(this.cookTimer + 1);
                if (this.cookTimer >= this.getCookingTime()) {
                    this.result = HFApi.COOKING.getResult(this.getUtensil(), this.ingredients);
                    this.cooking = false;
                    this.ingredients = new ArrayList();
                    this.cookTimer = 0;
                    this.func_70296_d();
                }
                if (!this.hasPrerequisites()) {
                    this.cooking = false;
                    this.func_70296_d();
                }
            }
        } else if (this.isCooking()) {
            this.animate();
        }
    }

    public boolean addIngredient(ItemStack stack) {
        if (this.ingredients.size() >= 20) {
            return false;
        }
        if (!this.hasPrerequisites()) {
            return false;
        }
        if (HFApi.COOKING.getCookingComponents(stack).size() < 1) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        ItemStack clone = this.getRealIngredient(stack);
        clone.field_77994_a = 1;
        this.ingredients.add(clone);
        this.cooking = true;
        this.cookTimer = 0;
        this.func_70296_d();
        return true;
    }

    private ItemStack getRealIngredient(ItemStack stack) {
        ItemStack alt = null;
        if (stack.func_77973_b() instanceof IAltItem) {
            alt = ((IAltItem)stack.func_77973_b()).getAlternativeWhenCooking(stack);
        }
        return alt == null ? stack.func_77946_l() : alt.func_77946_l();
    }

    public void setFromPacket(boolean isCooking, ArrayList<ItemStack> ingredientList, ItemStack resultStack) {
        int size = this.ingredients.size();
        this.cooking = isCooking;
        this.ingredients = ingredientList;
        this.result = resultStack;
        if (isCooking) {
            this.rotations[size] = this.field_145850_b.field_73012_v.nextFloat() * 360.0f;
            this.offset1[size] = 0.5f - this.field_145850_b.field_73012_v.nextFloat();
            this.offset2[size] = this.field_145850_b.field_73012_v.nextFloat() / 1.75f;
            this.heightOffset[size] = 0.5f + (float)this.ingredients.size() * 0.001f;
        }
    }

    @Override
    public IMessage getPacket() {
        return new PacketSyncCooking(this.field_145850_b.field_73011_w.getDimension(), this.func_174877_v(), this.orientation, this.cooking, this.ingredients, this.result);
    }

    @Override
    public Packet<?> getDescriptionPacket() {
        return PacketHandler.getPacket((IMessage)this.getPacket());
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendAround((IMessage)this.getPacket(), (TileEntity)this);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cooking = nbt.func_74767_n("IsCooking");
        this.cookTimer = nbt.func_74765_d("CookingTimer");
        if (nbt.func_74764_b("IngredientsInside")) {
            NBTTagList is = nbt.func_150295_c("IngredientsInside", 10);
            for (int i = 0; i < is.func_74745_c(); ++i) {
                this.ingredients.add(StackHelper.getItemStackFromNBT(is.func_150305_b(i)));
            }
        }
        if (nbt.func_74764_b("Count")) {
            this.result = StackHelper.getItemStackFromNBT(nbt);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("IsCooking", this.cooking);
        nbt.func_74777_a("CookingTimer", this.cookTimer);
        if (this.ingredients.size() > 0) {
            NBTTagList is = new NBTTagList();
            for (ItemStack ingredient : this.ingredients) {
                is.func_74742_a((NBTBase)StackHelper.writeItemStackToNBT(new NBTTagCompound(), ingredient));
            }
            nbt.func_74782_a("IngredientsInside", (NBTBase)is);
        }
        if (this.result != null) {
            StackHelper.writeItemStackToNBT(nbt, this.result);
        }
    }

    public boolean isAbove(Utensil utensil) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (tile instanceof TileCooking) {
            return ((TileCooking)tile).getUtensil() == utensil;
        }
        return false;
    }

    public static abstract class TileCookingTicking
    extends TileCooking
    implements ITickable {
    }
}

