/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.blocks;

import joshie.harvest.blocks.BlockCookware;
import joshie.harvest.blocks.BlockCrop;
import joshie.harvest.blocks.BlockDirt;
import joshie.harvest.blocks.BlockFarmland;
import joshie.harvest.blocks.BlockFlower;
import joshie.harvest.blocks.BlockGoddessWater;
import joshie.harvest.blocks.BlockPreview;
import joshie.harvest.blocks.BlockStone;
import joshie.harvest.blocks.BlockWood;
import joshie.harvest.blocks.tiles.TileCooking;
import joshie.harvest.blocks.tiles.TileCounter;
import joshie.harvest.blocks.tiles.TileFridge;
import joshie.harvest.blocks.tiles.TileFryingPan;
import joshie.harvest.blocks.tiles.TileMarker;
import joshie.harvest.blocks.tiles.TileMixer;
import joshie.harvest.blocks.tiles.TileOven;
import joshie.harvest.blocks.tiles.TilePot;
import joshie.harvest.buildings.render.PreviewRender;
import joshie.harvest.cooking.render.SpecialRendererCounter;
import joshie.harvest.cooking.render.SpecialRendererFryingPan;
import joshie.harvest.cooking.render.SpecialRendererMixer;
import joshie.harvest.cooking.render.SpecialRendererPot;
import joshie.harvest.core.helpers.generic.RegistryHelper;
import joshie.harvest.core.util.base.BlockHFBase;
import joshie.harvest.core.util.base.BlockHFBaseEnum;
import joshie.harvest.crops.CropStateMapper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HFBlocks {
    public static final Fluid GODDESS = HFBlocks.registerFluid(new Fluid("hf_goddess_water", new ResourceLocation("blocks/hf_goddess_water_still"), new ResourceLocation("blocks/hf_goddess_water_flow")).setRarity(EnumRarity.RARE));
    public static final BlockFluidClassic GODDESS_WATER = new BlockGoddessWater(GODDESS).setUnlocalizedName("goddess.water");
    public static final BlockHFBaseEnum COOKWARE = new BlockCookware().setUnlocalizedName("cookware");
    public static final BlockHFBaseEnum FARMLAND = new BlockFarmland().setUnlocalizedName("farmland");
    public static final BlockHFBaseEnum CROPS = new BlockCrop().setUnlocalizedName("crops.block");
    public static final BlockHFBase FLOWERS = new BlockFlower().setUnlocalizedName("flowers.block");
    public static BlockHFBaseEnum STONE = new BlockStone().setUnlocalizedName("stone");
    public static BlockHFBaseEnum DIRT = new BlockDirt().setUnlocalizedName("dirt");
    public static BlockHFBaseEnum WOOD_MACHINES = new BlockWood().setUnlocalizedName("woodware");
    public static BlockPreview PREVIEW = (BlockPreview)new BlockPreview().setUnlocalizedName("preview");

    public static void preInit() {
        GODDESS.setBlock((Block)GODDESS_WATER);
        RegistryHelper.registerTiles("harvestfestival", TileCooking.class, TileFridge.class, TileFryingPan.class, TileCounter.class, TileMarker.class, TileMixer.class, TileOven.class, TilePot.class);
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInitClient() {
        ModelLoader.setCustomStateMapper((Block)CROPS, (IStateMapper)new CropStateMapper());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMarker.class, (TileEntitySpecialRenderer)new PreviewRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileFryingPan.class, (TileEntitySpecialRenderer)new SpecialRendererFryingPan());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePot.class, (TileEntitySpecialRenderer)new SpecialRendererPot());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCounter.class, (TileEntitySpecialRenderer)new SpecialRendererCounter());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMixer.class, (TileEntitySpecialRenderer)new SpecialRendererMixer());
    }

    private static Fluid registerFluid(Fluid fluid) {
        FluidRegistry.registerFluid((Fluid)fluid);
        return fluid;
    }
}

