/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.blocks;

import java.util.HashMap;
import java.util.List;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.buildings.IBuilding;
import joshie.harvest.blocks.tiles.TileMarker;
import joshie.harvest.buildings.BuildingRegistry;
import joshie.harvest.buildings.loader.HFBuildings;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.config.General;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.UUIDHelper;
import joshie.harvest.core.util.base.BlockHFBaseEnum;
import joshie.harvest.npc.entity.EntityNPCBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class BlockPreview
extends BlockHFBaseEnum<Direction> {
    public ItemStack getItemStack(IBuilding building) {
        ItemStack stack = new ItemStack((Block)this);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("Building", building.getResource().toString());
        return stack;
    }

    public BlockPreview() {
        super(Material.field_151575_d, Direction.class, HFTab.TOWN);
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            IBuilding building;
            int next = ((Direction)((Object)this.getEnumFromState(state))).ordinal() + 1;
            if (next >= 11) {
                next = 0;
            }
            if ((building = ((TileMarker)world.func_175625_s(pos)).getBuilding()) != null) {
                world.func_180501_a(pos, this.func_176203_a(next), 2);
                ((TileMarker)world.func_175625_s(pos)).setBuilding(building);
                return true;
            }
            return false;
        }
        Direction direction = (Direction)((Object)this.getEnumFromState(state));
        TileMarker marker = (TileMarker)world.func_175625_s(pos);
        EntityNPCBuilder builder = HFTrackers.getPlayerTracker((EntityPlayer)player).getBuilder(world);
        if (builder != null && !builder.isBuilding()) {
            builder.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            builder.startBuilding(marker.getBuilding(), pos, direction.getMirror(), direction.getRotation(), UUIDHelper.getPlayerUUID(player));
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileMarker();
    }

    public IBuilding getBuildingFromStack(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return HFBuildings.null_building;
        }
        IBuilding building = HFApi.BUILDINGS.getBuildingFromName(new ResourceLocation(stack.func_77978_p().func_74779_i("Building")));
        return building == null ? HFBuildings.null_building : building;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        IBuilding building = this.getBuildingFromStack(stack);
        if (building != null) {
            TileMarker marker = (TileMarker)world.func_175625_s(pos);
            marker.setBuilding(building);
            if (!world.field_72995_K) {
                HFTrackers.getPlayerTracker((EntityPlayer)((EntityPlayer)player)).getBuilder(world);
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileMarker marker = (TileMarker)world.func_175625_s(pos);
        IBuilding building = marker.getBuilding();
        if (building == null) {
            return null;
        }
        return this.getItemStack(building);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (tab != HFTab.TOWN) {
            return;
        }
        if (General.DEBUG_MODE) {
            for (IBuilding building : BuildingRegistry.buildings.values()) {
                list.add(this.getItemStack(building));
            }
        }
    }

    @Override
    public String getItemStackDisplayName(ItemStack stack) {
        return this.getBuildingFromStack(stack).getLocalisedName();
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 105;
    }

    static {
        for (Direction direction : Direction.values()) {
            Direction.map.put((Pair<Mirror, Rotation>)Pair.of((Object)direction.getMirror(), (Object)direction.getRotation()), direction);
        }
    }

    public static enum Direction implements IStringSerializable
    {
        MN_R0(Mirror.NONE, Rotation.NONE),
        MN_R90(Mirror.NONE, Rotation.CLOCKWISE_90),
        MN_R180(Mirror.NONE, Rotation.CLOCKWISE_180),
        MN_R270(Mirror.NONE, Rotation.COUNTERCLOCKWISE_90),
        MLR_R0(Mirror.LEFT_RIGHT, Rotation.NONE),
        MLR_R90(Mirror.LEFT_RIGHT, Rotation.CLOCKWISE_90),
        MLR_R180(Mirror.LEFT_RIGHT, Rotation.CLOCKWISE_180),
        MLR_R270(Mirror.LEFT_RIGHT, Rotation.COUNTERCLOCKWISE_90),
        MFB_R0(Mirror.FRONT_BACK, Rotation.NONE),
        MFB_R90(Mirror.FRONT_BACK, Rotation.CLOCKWISE_90),
        MFB_R180(Mirror.FRONT_BACK, Rotation.CLOCKWISE_180),
        MFB_R270(Mirror.FRONT_BACK, Rotation.COUNTERCLOCKWISE_90);

        public static final HashMap<Pair<Mirror, Rotation>, Direction> map;
        private final Mirror mirror;
        private final Rotation rotation;

        private Direction(Mirror mirror, Rotation rotation) {
            this.mirror = mirror;
            this.rotation = rotation;
        }

        public Mirror getMirror() {
            return this.mirror;
        }

        public Rotation getRotation() {
            return this.rotation;
        }

        public IBlockState withDirection(IBlockState state) {
            return state.func_185902_a(this.mirror).func_185907_a(this.rotation);
        }

        public static Direction withMirrorAndRotation(Mirror mirror, Rotation rotation) {
            return map.get(Pair.of((Object)mirror, (Object)rotation));
        }

        public String func_176610_l() {
            return this.toString().toLowerCase();
        }

        static {
            map = new HashMap();
        }
    }
}

