/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.blocks;

import java.util.Random;
import java.util.WeakHashMap;
import joshie.harvest.api.WorldLocation;
import joshie.harvest.blocks.HFBlocks;
import joshie.harvest.core.util.base.BlockHFBaseEnum;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFarmland
extends BlockHFBaseEnum<Moisture> {
    private final WeakHashMap<WorldLocation, Long> timePlaced = new WeakHashMap();
    private final AxisAlignedBB FARMLAND_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
    private final IBlockState WET;

    public BlockFarmland() {
        super(Material.field_151578_c, Moisture.class, null);
        this.func_149675_a(true);
        this.func_149713_g(255);
        this.func_149672_a(SoundType.field_185849_b);
        this.WET = this.getStateFromEnum(Moisture.WET);
        this.func_149722_s();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.FARMLAND_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.func_175727_C(pos.func_177984_a())) {
            WorldLocation location = new WorldLocation(world.field_73011_w.getDimension(), pos);
            Long time = this.timePlaced.get(location);
            if (time == null) {
                this.timePlaced.put(location, System.currentTimeMillis());
            } else if (System.currentTimeMillis() - time >= 60000L) {
                world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
            }
        } else if (state != this.WET) {
            world.func_180501_a(pos, this.WET, 2);
        }
    }

    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        super.onNeighborBlockChange(worldIn, pos, state, neighborBlock);
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            worldIn.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!worldIn.field_72995_K && worldIn.field_73012_v.nextFloat() < fallDistance - 0.5f && entityIn instanceof EntityLivingBase && (entityIn instanceof EntityPlayer || worldIn.func_82736_K().func_82766_b("mobGriefing")) && entityIn.field_70130_N * entityIn.field_70130_N * entityIn.field_70131_O > 0.512f) {
            worldIn.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                return !iblockstate.func_185914_p() && block != HFBlocks.FARMLAND && block != Blocks.field_185774_da;
            }
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Blocks.field_150346_d.func_180660_a(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT), rand, fortune);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Blocks.field_150346_d);
    }

    public static enum Moisture implements IStringSerializable
    {
        DRY,
        WET;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

