/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.blocks;

import java.util.Random;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.IAnimalFeeder;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.api.crops.IBreakCrops;
import joshie.harvest.api.crops.ICrop;
import joshie.harvest.api.crops.ICropData;
import joshie.harvest.api.crops.IStateHandler;
import joshie.harvest.core.config.Crops;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.AnimalHelper;
import joshie.harvest.core.helpers.CropHelper;
import joshie.harvest.core.helpers.SeedHelper;
import joshie.harvest.core.helpers.WorldHelper;
import joshie.harvest.core.util.base.BlockHFBaseEnum;
import joshie.harvest.crops.HFCrops;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCrop
extends BlockHFBaseEnum<Stage>
implements IPlantable,
IGrowable,
IAnimalFeeder {
    public static final AxisAlignedBB CROP_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockCrop() {
        super(Material.field_151585_k, Stage.class, null);
        this.func_149722_s();
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149675_a(Crops.ALWAYS_GROW);
        this.func_149649_H();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (Crops.ALWAYS_GROW && !world.field_72995_K) {
            float chance;
            Stage stage = (Stage)((Object)this.getEnumFromState(state));
            if (stage == Stage.WITHERED) {
                return;
            }
            if (world.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt((int)(25.0f / (chance = BlockCrop.getGrowthChance(this, world, pos))) + 1) == 0) {
                HFTrackers.getCropTracker().grow(world, pos);
            }
        }
    }

    private static float getGrowthChance(Block block, World world, BlockPos pos) {
        boolean yTrue;
        float f = 1.0f;
        BlockPos posDown = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState state = world.func_180495_p(posDown.func_177982_a(i, 0, j));
                if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, posDown.func_177982_a(i, 0, j), EnumFacing.UP, (IPlantable)block)) {
                    f1 = 1.0f;
                    if (state.func_177230_c().isFertile(world, posDown.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos posNorth = pos.func_177978_c();
        BlockPos posSouth = pos.func_177968_d();
        BlockPos posWest = pos.func_177976_e();
        BlockPos posEast = pos.func_177974_f();
        boolean xTrue = block == world.func_180495_p(posWest).func_177230_c() || block == world.func_180495_p(posEast).func_177230_c();
        boolean bl = yTrue = block == world.func_180495_p(posNorth).func_177230_c() || block == world.func_180495_p(posSouth).func_177230_c();
        if (xTrue && yTrue) {
            f /= 2.0f;
        } else {
            boolean cornerTrue;
            boolean bl2 = cornerTrue = block == world.func_180495_p(posWest.func_177978_c()).func_177230_c() || block == world.func_180495_p(posEast.func_177978_c()).func_177230_c() || block == world.func_180495_p(posEast.func_177968_d()).func_177230_c() || block == world.func_180495_p(posWest.func_177968_d()).func_177230_c();
            if (cornerTrue) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
        if (stateUp.func_177230_c() != this) {
            return false;
        }
        Stage aboveStage = (Stage)((Object)this.getEnumFromState(stateUp));
        Stage thisStage = (Stage)((Object)this.getEnumFromState(state));
        if (stateUp.func_177230_c() == this) {
            if (thisStage == Stage.FRESH) {
                return aboveStage == Stage.FRESH_DOUBLE;
            }
            if (thisStage == Stage.WITHERED) {
                return aboveStage == Stage.WITHERED_DOUBLE;
            }
        }
        return false;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        Stage stage = (Stage)((Object)this.getEnumFromState(state));
        ItemStack held = player.func_184607_cu();
        ICropData crop = HFApi.CROPS.getCropAtLocation(world, pos);
        if (crop.getCrop().growsToSide() != null && crop.getStage() == crop.getCrop().getStages()) {
            return 0.0f;
        }
        if (held == null || !(held.func_77973_b() instanceof IBreakCrops)) {
            return stage == Stage.WITHERED ? 0.0f : 0.75f;
        }
        return ((IBreakCrops)held.func_77973_b()).getStrengthVSCrops(player, world, pos, state, held);
    }

    public static IStateHandler.PlantSection getSection(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int stage = state.func_177230_c().func_176201_c(state);
        IStateHandler.PlantSection section = IStateHandler.PlantSection.BOTTOM;
        if (stage == Stage.WITHERED_DOUBLE.ordinal() || stage == Stage.FRESH_DOUBLE.ordinal()) {
            section = IStateHandler.PlantSection.TOP;
        }
        return section;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        Stage stage = (Stage)((Object)this.getEnumFromState(state));
        if (stage == Stage.WITHERED || stage == Stage.WITHERED_DOUBLE) {
            return false;
        }
        if (player.func_70093_af()) {
            return false;
        }
        IStateHandler.PlantSection section = BlockCrop.getSection((IBlockAccess)world, pos);
        ICropData data = HFApi.CROPS.getCropAtLocation(world, pos);
        if (data == null || data.getCrop().requiresSickle() || data.getCrop().growsToSide() != null) {
            return false;
        }
        if (section == IStateHandler.PlantSection.BOTTOM) {
            return CropHelper.harvestCrop(player, world, pos);
        }
        return CropHelper.harvestCrop(player, world, pos.func_177977_b());
    }

    public void onNeighborBlockChange(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (!world.field_72995_K) {
            IBlockState soil = world.func_180495_p(pos.func_177977_b());
            ICrop crop = HFApi.CROPS.getCropAtLocation(world, pos).getCrop();
            if (crop != null && crop.getSoilHandler() != null && !crop.getSoilHandler().canSustainPlant(soil, (IBlockAccess)world, pos, this)) {
                world.func_175698_g(pos);
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        boolean isSickle;
        Stage stage = (Stage)((Object)this.getEnumFromState(state));
        if (stage == Stage.WITHERED || stage == Stage.WITHERED_DOUBLE) {
            return world.func_175698_g(pos);
        }
        IStateHandler.PlantSection section = BlockCrop.getSection((IBlockAccess)world, pos);
        ICropData data = HFApi.CROPS.getCropAtLocation(world, pos);
        if (data == null) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        ICrop crop = data.getCrop();
        boolean bl = isSickle = player.func_184607_cu() != null && player.func_184607_cu().func_77973_b() instanceof IBreakCrops;
        if (isSickle || !crop.requiresSickle()) {
            if (section == IStateHandler.PlantSection.BOTTOM) {
                CropHelper.harvestCrop(player, world, pos);
            } else {
                CropHelper.harvestCrop(player, world, pos.func_177977_b());
            }
        }
        return world.func_175698_g(pos);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Stage stage = (Stage)((Object)this.getEnumFromState(state));
        if (stage == Stage.FRESH || stage == Stage.WITHERED) {
            HFTrackers.getCropTracker().removeCrop(world, pos);
        } else if (stage == Stage.FRESH_DOUBLE || stage == Stage.WITHERED_DOUBLE) {
            world.func_175698_g(pos.func_177977_b());
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (world instanceof World) {
            Stage stage = (Stage)((Object)this.getEnumFromState(state));
            return CropHelper.getCropBoundingBox((World)world, pos, stage.getSection(), stage.isWithered());
        }
        return CROP_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (this.getEnumFromState(state) == Stage.WITHERED) {
            return new ItemStack((Block)Blocks.field_150330_I);
        }
        ICropData data = HFApi.CROPS.getCropAtLocation(world, pos);
        return SeedHelper.getSeedsFromCrop(data.getCrop());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        World world = WorldHelper.getWorld(access);
        if (world != null) {
            Stage stage = (Stage)((Object)this.getEnumFromState(state));
            if (stage.getSection() == IStateHandler.PlantSection.TOP) {
                return CropHelper.getBlockState(world, pos.func_177977_b(), stage.getSection(), stage.isWithered());
            }
            return CropHelper.getBlockState(world, pos, stage.getSection(), stage.isWithered());
        }
        return state;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        if (this.getEnumFromState(state) == Stage.WITHERED) {
            return false;
        }
        if (Crops.ENABLE_BONEMEAL) {
            return HFTrackers.getCropTracker().canBonemeal(world, pos);
        }
        return false;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        HFTrackers.getCropTracker().grow(world, pos);
    }

    public boolean canFeedAnimal(IAnimalTracked tracked, World world, BlockPos pos) {
        int stage;
        ICropData crop;
        ICrop theCrop;
        if (AnimalHelper.eatsGrass(tracked) && (theCrop = (crop = HFApi.CROPS.getCropAtLocation(world, pos)).getCrop()) == HFCrops.grass && (stage = crop.getStage()) > 5) {
            HFTrackers.getCropTracker().plantCrop(tracked.getData().getOwner(), world, pos, theCrop, stage - 5);
            return true;
        }
        return false;
    }

    public static enum Stage implements IStringSerializable
    {
        FRESH(false, IStateHandler.PlantSection.BOTTOM),
        WITHERED(false, IStateHandler.PlantSection.BOTTOM),
        FRESH_DOUBLE(false, IStateHandler.PlantSection.TOP),
        WITHERED_DOUBLE(true, IStateHandler.PlantSection.TOP);

        private final boolean isWithered;
        private final IStateHandler.PlantSection section;

        private Stage(boolean isWithered, IStateHandler.PlantSection section) {
            this.isWithered = true;
            this.section = section;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase();
        }

        public boolean isWithered() {
            return this.isWithered;
        }

        public IStateHandler.PlantSection getSection() {
            return this.section;
        }
    }
}

