/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.blocks;

import joshie.harvest.HarvestFestival;
import joshie.harvest.blocks.HFBlocks;
import joshie.harvest.blocks.tiles.TileCooking;
import joshie.harvest.blocks.tiles.TileCounter;
import joshie.harvest.blocks.tiles.TileFridge;
import joshie.harvest.blocks.tiles.TileFryingPan;
import joshie.harvest.blocks.tiles.TileHeatable;
import joshie.harvest.blocks.tiles.TileMixer;
import joshie.harvest.blocks.tiles.TileOven;
import joshie.harvest.blocks.tiles.TilePot;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.helpers.generic.ItemHelper;
import joshie.harvest.core.util.base.BlockHFBaseEnumRotatableTile;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCookware
extends BlockHFBaseEnumRotatableTile<Cookware> {
    private static final AxisAlignedBB FRYING_PAN_AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.15f, (double)0.8f);
    private static final AxisAlignedBB MIXER_AABB = new AxisAlignedBB((double)0.275f, 0.0, (double)0.275f, (double)0.725f, (double)0.725f, (double)0.725f);
    private static final AxisAlignedBB POT_AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 0.375, (double)0.8f);
    private static Item cookware = null;

    public BlockCookware() {
        super(Material.field_76233_E, Cookware.class, HFTab.COOKING);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        Cookware cookware = (Cookware)((Object)this.getEnumFromState(state));
        return cookware == Cookware.FRIDGE_TOP ? false : (cookware == Cookware.MIXER ? layer == BlockRenderLayer.TRANSLUCENT : layer == BlockRenderLayer.CUTOUT_MIPPED);
    }

    @Override
    public String getToolType(Cookware cookware) {
        return cookware == Cookware.COUNTER ? "axe" : "pickaxe";
    }

    public Material func_149688_o(IBlockState state) {
        return this.getEnumFromState(state) == Cookware.COUNTER ? Material.field_151575_d : super.func_149688_o(state);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        Cookware cookware = (Cookware)((Object)this.getEnumFromState(state));
        switch (cookware) {
            case FRYING_PAN: {
                return FRYING_PAN_AABB;
            }
            case POT: {
                return POT_AABB;
            }
            case FRIDGE: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);
            }
            case FRIDGE_TOP: {
                return new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 1.0, 1.0);
            }
            case MIXER: {
                return MIXER_AABB;
            }
        }
        return field_185505_j;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        Cookware cookware = (Cookware)((Object)this.getEnumFromState(state));
        if (player.func_70093_af()) {
            return false;
        }
        if (cookware == Cookware.FRIDGE || cookware == Cookware.FRIDGE_TOP) {
            player.openGui((Object)HarvestFestival.instance, 3, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (cookware == Cookware.COUNTER) {
            ItemStack held = player.func_184586_b(hand);
            TileEntity tile2 = cookware == Cookware.COUNTER ? world.func_175625_s(pos) : world.func_175625_s(pos.func_177977_b());
            if (!(tile2 instanceof TileCounter)) {
                return false;
            }
            if (cookware == Cookware.COUNTER && held == null) {
                ((TileCooking)tile2).update();
            }
        }
        if ((tile = world.func_175625_s(pos)) instanceof TileCooking) {
            TileCooking cooking = (TileCooking)tile;
            ItemStack held = player.func_184586_b(hand);
            if (!cooking.canAddItems()) {
                if (!player.field_71071_by.func_70441_a(cooking.getResult()) && !world.field_72995_K) {
                    ItemHelper.spawnItem(world, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p(), cooking.getResult());
                }
                cooking.clear();
                return true;
            }
            if (held != null && !BlockCookware.isCookware(held) && cooking.addIngredient(held)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isCookware(ItemStack stack) {
        if (cookware == null) {
            cookware = Item.func_150898_a((Block)HFBlocks.COOKWARE);
        }
        return stack.func_77973_b() == cookware;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFridge) {
            world.func_180501_a(pos.func_177984_a(), this.getStateFromEnum(Cookware.FRIDGE_TOP), 2);
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        try {
            Cookware cookware = (Cookware)((Object)this.getEnumFromBlockPos((IBlockAccess)world, pos));
            if (cookware == Cookware.FRIDGE_TOP) {
                world.func_175698_g(pos.func_177977_b());
            } else if (cookware == Cookware.FRIDGE) {
                world.func_175698_g(pos.func_177984_a());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Cookware cookware = (Cookware)((Object)this.getEnumFromState(state));
        if (cookware == Cookware.FRIDGE_TOP) {
            world.func_175698_g(pos.func_177977_b());
        } else if (cookware == Cookware.FRIDGE) {
            world.func_175698_g(pos.func_177984_a());
        }
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.getEnumFromState(state) == Cookware.FRIDGE_TOP ? Cookware.FRIDGE.ordinal() : super.func_180651_a(state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.getEnumFromState(state) != Cookware.FRIDGE_TOP;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState ret = super.func_176221_a(state, world, pos);
        Cookware cookware = (Cookware)((Object)this.getEnumFromState(ret));
        if (cookware == Cookware.OVEN_OFF || cookware == Cookware.OVEN_ON) {
            TileEntity tile = world.func_175625_s(pos.func_177984_a());
            if (tile instanceof TileHeatable && ((TileHeatable)tile).isCooking()) {
                return ret.func_177226_a((IProperty)this.property, (Comparable)((Object)Cookware.OVEN_ON));
            }
            return ret.func_177226_a((IProperty)this.property, (Comparable)((Object)Cookware.OVEN_OFF));
        }
        return ret;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        Cookware cookware = (Cookware)((Object)this.getEnumFromState(state));
        switch (cookware) {
            case FRIDGE: {
                return new TileFridge();
            }
            case COUNTER: {
                return new TileCounter();
            }
            case POT: {
                return new TilePot();
            }
            case FRYING_PAN: {
                return new TileFryingPan();
            }
            case MIXER: {
                return new TileMixer();
            }
            case OVEN_OFF: {
                return new TileOven();
            }
            case OVEN_ON: {
                return new TileOven();
            }
        }
        return null;
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 99;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean isValidTab(CreativeTabs tab, Cookware cookware) {
        return cookware.isReal ? super.isValidTab(tab, cookware) : false;
    }

    public static enum Cookware implements IStringSerializable
    {
        FRIDGE_TOP(false),
        FRIDGE(true),
        COUNTER(true),
        POT(true),
        FRYING_PAN(true),
        MIXER(true),
        OVEN_OFF(true),
        OVEN_ON(false),
        COUNTER_IC(false),
        COUNTER_OC(false);

        private final boolean isReal;

        private Cookware(boolean isReal) {
            this.isReal = isReal;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

