/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.asm.transformers;

import java.util.HashSet;
import joshie.harvest.asm.transformers.AbstractASM;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class PlayerWakeTransformer
extends AbstractASM {
    @Override
    public boolean isClass(String name) {
        return name.equals("net.minecraft.entity.player.EntityPlayer") || name.equals("zs");
    }

    @Override
    public boolean isVisitor() {
        return false;
    }

    private boolean isOnUpdate(String name, String descriptor) {
        return descriptor.equals("()V") && (name.equals("onUpdate") || name.equals("func_70071_h_") || name.equals("m"));
    }

    private boolean isWakeupPlayer(String name, String descriptor) {
        return descriptor.equals("(ZZZ)V") && (name.equals("wakeUpPlayer") || name.equals("func_70999_a") || name.equals("a"));
    }

    private boolean isDaytime(String name, String descriptor) {
        return descriptor.equals("()Z") && (name.equals("isDaytime") || name.equals("func_72935_r") || name.equals("B"));
    }

    @Override
    public byte[] transform(byte[] data) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(data);
        classReader.accept((ClassVisitor)classNode, 0);
        block0: for (MethodNode method : classNode.methods) {
            if (!this.isOnUpdate(method.name, method.desc)) continue;
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode node = method.instructions.get(i);
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode mNode = (MethodInsnNode)node;
                if (!this.isWakeupPlayer(mNode.name, mNode.desc) || !(method.instructions.get(i - 8) instanceof MethodInsnNode)) continue;
                MethodInsnNode previous = (MethodInsnNode)method.instructions.get(i - 8);
                if (!this.isDaytime(previous.name, previous.desc)) continue;
                HashSet<AbstractInsnNode> remove = new HashSet<AbstractInsnNode>();
                for (int j = 0; j <= 5; ++j) {
                    remove.add(method.instructions.get(i - j));
                }
                for (AbstractInsnNode instruction : remove) {
                    method.instructions.remove(instruction);
                }
                break block0;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

