/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.asm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import joshie.harvest.asm.transformers.AbstractASM;
import joshie.harvest.asm.transformers.SnowTransformer;
import joshie.harvest.asm.transformers.WeatherTransformer;
import joshie.harvest.core.config.HFConfig;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class HFOverride
implements IFMLLoadingPlugin,
IClassTransformer {
    public static boolean isObfuscated = false;
    private static List<AbstractASM> asm = new ArrayList<AbstractASM>();

    public byte[] transform(String name, String transformedName, byte[] data) {
        byte[] modified = data;
        for (AbstractASM a : asm) {
            if (!a.isActive(HFConfig.asm) || !a.isClass(name)) continue;
            if (a.isVisitor()) {
                ClassReader cr = new ClassReader(modified);
                ClassWriter cw = new ClassWriter(1);
                ClassVisitor cv = a.newInstance(cw);
                cr.accept(cv, 8);
                modified = cw.toByteArray();
            }
            modified = a.transform(modified);
        }
        return modified;
    }

    public String[] getASMTransformerClass() {
        return new String[]{HFOverride.class.getName()};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        isObfuscated = (Boolean)data.get("runtimeDeobfuscationEnabled");
    }

    public String getAccessTransformerClass() {
        return null;
    }

    static {
        asm.add(new SnowTransformer());
        asm.add(new WeatherTransformer());
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping();
        Gson gson = builder.create();
        HFConfig.initASM(gson);
    }
}

