/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.asm;

public class ASMHelper {
    public static String toInternalClassName(String className) {
        return className.replace('.', '/');
    }

    public static boolean isDescriptor(String descriptor) {
        return descriptor.length() == 1 || descriptor.startsWith("L") && descriptor.endsWith(";");
    }

    public static String toDescriptor(String className) {
        return ASMHelper.isDescriptor(className) ? className : "L" + ASMHelper.toInternalClassName(className) + ";";
    }

    public static String toMethodDescriptor(String returnType, String ... paramTypes) {
        StringBuilder paramDescriptors = new StringBuilder();
        for (String paramType : paramTypes) {
            paramDescriptors.append(ASMHelper.toDescriptor(paramType));
        }
        return "(" + paramDescriptors.toString() + ")" + ASMHelper.toDescriptor(returnType);
    }
}

