/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api.trees;

import joshie.harvest.api.crops.Crop;
import joshie.harvest.api.crops.GrowthHandler;
import joshie.harvest.api.trees.GrowthHandlerTree;
import joshie.harvest.api.trees.StateHandlerTree;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class Tree
extends Crop {
    public static final GrowthHandler TREE_GROWTH = new GrowthHandlerTree();
    private IBlockState log = Blocks.field_150364_r.func_176223_P();
    private int maturity;

    public Tree(ResourceLocation key) {
        super(key);
        this.setGrowthHandler(TREE_GROWTH);
        this.setNoWaterRequirements();
    }

    public int getStagesToMaturity() {
        return this.maturity;
    }

    public Tree setLogs(IBlockState logs) {
        this.log = logs;
        return this;
    }

    public ItemStack getWoodStack() {
        return new ItemStack(this.log.func_177230_c(), 1, this.log.func_177230_c().func_176201_c(this.log));
    }

    public Tree setStageLength(int seeds, int sapling, int juvenile, int maturity) {
        this.maturity = seeds + sapling + juvenile + maturity;
        this.setStages(this.maturity - maturity);
        this.setRegrow(this.maturity - 3);
        this.setStateHandler(new StateHandlerTree(this.log, seeds, sapling, juvenile));
        return this;
    }

    public Tree setFruitRegrow(int regrow) {
        this.setRegrow(this.getStagesToMaturity() - regrow);
        return this;
    }
}

