/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api.trees;

import joshie.harvest.api.crops.IStateHandler;
import joshie.harvest.api.crops.StateHandlerDefault;
import joshie.harvest.api.trees.Tree;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class StateHandlerTree
extends StateHandlerDefault<Tree> {
    private final IBlockState log;
    private final int stage1;
    private final int stage2;
    private final int stage3;

    public StateHandlerTree(IBlockState log, int stage1, int stage2, int stage3) {
        super(3);
        this.log = log;
        this.stage1 = stage1;
        this.stage2 = stage1 + stage2;
        this.stage3 = stage1 + stage2 + stage3;
    }

    public IBlockState getState(IBlockAccess world, BlockPos pos, IStateHandler.PlantSection section, Tree tree, int stage, boolean withered) {
        if (stage <= this.stage1) {
            return this.getState(1);
        }
        if (stage <= this.stage2) {
            return this.getState(2);
        }
        if (stage < this.stage3) {
            return this.getState(3);
        }
        return this.log;
    }

    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IStateHandler.PlantSection section, Tree tree, int stage, boolean withered) {
        return stage >= this.stage2 ? Block.field_185505_j : CROP_AABB;
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockAccess world, BlockPos pos, IStateHandler.PlantSection section, Tree tree, int stage, boolean withered) {
        return stage >= this.stage3 ? Block.field_185505_j : Block.field_185506_k;
    }
}

