/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api.trees;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.crops.Crop;
import joshie.harvest.api.crops.GrowthHandler;
import joshie.harvest.api.trees.Tree;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GrowthHandlerTree
extends GrowthHandler<Tree> {
    public boolean canGrow(World world, BlockPos pos, Tree tree) {
        return true;
    }

    public int grow(World world, BlockPos pos, Tree tree, int stage) {
        if (HFApi.calendar.getSeasonAtCoordinates(world, pos) == Season.WINTER) {
            return stage;
        }
        if (stage == tree.getStages() - 1) {
            this.growTree(world, pos);
        }
        if (stage < tree.getStagesToMaturity()) {
            ++stage;
        }
        if (stage >= tree.getStagesToMaturity() && this.isCorrectSeason(world, pos, tree)) {
            this.growFruit(world, pos);
            return tree.getRegrowStage();
        }
        return stage;
    }

    public boolean canPlantSeedAt(World world, BlockPos pos, IBlockState soil, Tree tree, BlockPos original) {
        return world.func_175623_d(pos.func_177974_f()) && world.func_175623_d(pos.func_177976_e()) && world.func_175623_d(pos.func_177978_c()) && world.func_175623_d(pos.func_177968_d()) && world.func_175623_d(pos.func_177978_c().func_177974_f()) && world.func_175623_d(pos.func_177978_c().func_177976_e()) && world.func_175623_d(pos.func_177978_c().func_177976_e()) && world.func_175623_d(pos.func_177968_d().func_177974_f()) && pos.equals((Object)original) && super.canPlantSeedAt(world, pos, soil, (Crop)tree, original);
    }

    public boolean canHarvest(Tree tree, int stage) {
        return false;
    }

    protected void growTree(World world, BlockPos pos) {
    }

    protected void growFruit(World world, BlockPos pos) {
    }
}

