/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api.quests;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quests.Quest;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class QuestQuestion
extends Quest {
    protected final Quest.Selection selection;
    public boolean isCompletedEarly;

    public QuestQuestion(Quest.Selection selection) {
        this.selection = selection;
    }

    @Override
    public Quest.Selection getSelection(EntityPlayer player, INPC npc) {
        return this.quest_stage <= 0 ? this.selection : null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.isCompletedEarly = nbt.func_74767_n("IsCompleted");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("IsCompleted", this.isCompletedEarly);
        return nbt;
    }

    public static abstract class QuestSelection<Q extends QuestQuestion>
    extends Quest.Selection<Q> {
        public QuestSelection(String title, String line1, String line2) {
            super(title, line1, line2);
        }

        public QuestSelection(String title, String line1, String line2, String line3) {
            super(title, line1, line2, line3);
        }

        @Override
        public Event.Result onSelected(EntityPlayer player, EntityLiving entity, INPC npc, QuestQuestion quest, int option) {
            if (option == 1) {
                quest.increaseStage(player);
            } else {
                quest.isCompletedEarly = true;
                HFApi.quests.completeEarly(quest, player);
            }
            return Event.Result.ALLOW;
        }
    }
}

