/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api.quests;

import java.util.Set;
import javax.annotation.Nullable;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.npc.INPC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.RegistryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Quest
extends IForgeRegistryEntry.Impl<Quest> {
    public static final IForgeRegistry<Quest> REGISTRY = new RegistryBuilder().setName(new ResourceLocation("harvestfestival", "quests")).setType(Quest.class).setIDRange(0, 32000).create();
    public int quest_stage;
    private INPC[] npcs;

    public final INPC[] getNPCs() {
        return this.npcs;
    }

    public boolean canStartQuest(Set<Quest> active, Set<Quest> finished) {
        return true;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isRealQuest() {
        return true;
    }

    public final Quest setNPCs(INPC ... npcs) {
        this.npcs = npcs;
        return this;
    }

    public final int getStage() {
        return this.quest_stage;
    }

    public final void increaseStage(EntityPlayer player) {
        HFApi.quests.increaseStage(this, player);
    }

    public final Quest setStage(int quest_stage) {
        this.quest_stage = quest_stage;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalized(String quest, Object ... format) {
        if (format.length == 0) {
            return I18n.func_74838_a((String)(this.getRegistryName().func_110624_b() + ".quest." + this.getRegistryName().func_110623_a() + "." + quest.replace("_", "")));
        }
        return I18n.func_74837_a((String)(this.getRegistryName().func_110624_b() + ".quest." + this.getRegistryName().func_110623_a() + "." + quest.replace("_", "")), (Object[])format);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedScript(EntityPlayer player, EntityLiving entity, INPC npc) {
        return null;
    }

    @Nullable
    public Selection getSelection(EntityPlayer player, INPC npc) {
        return null;
    }

    public void onStageChanged(EntityPlayer player, int previous, int stage) {
    }

    public void onChatOpened(EntityPlayer player, EntityLiving entity, INPC npc) {
    }

    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc, boolean wasSneaking) {
        this.onChatClosed(player, entity, npc);
    }

    @Deprecated
    public void onChatClosed(EntityPlayer player, EntityLiving entity, INPC npc) {
    }

    public void onQuestCompleted(EntityPlayer player) {
    }

    public final void complete(EntityPlayer player) {
        HFApi.quests.completeQuest(this, player);
    }

    public final void takeHeldStack(EntityPlayer player, int amount) {
        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, amount);
    }

    public final void rewardItem(EntityPlayer player, ItemStack stack) {
        HFApi.quests.rewardItem(this, player, stack);
    }

    public final void rewardGold(EntityPlayer player, long gold) {
        HFApi.quests.rewardGold(player, gold);
    }

    public final void rewardEntity(EntityPlayer player, String entity) {
        HFApi.quests.rewardEntity(this, player, entity);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.quest_stage = nbt.func_74765_d("Stage");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74777_a("Stage", (short)this.quest_stage);
        return nbt;
    }

    public boolean equals(Object o) {
        return o instanceof Quest && this.getRegistryName() != null && this.getRegistryName().equals((Object)((Quest)((Object)o)).getRegistryName());
    }

    public int hashCode() {
        return this.getRegistryName() == null ? 0 : this.getRegistryName().hashCode();
    }

    public void onEntityInteract(EntityPlayer player, @Nullable ItemStack held, EnumHand hand, Entity target) {
    }

    public void onRightClickBlock(EntityPlayer player, BlockPos pos, EnumFacing face) {
    }

    public static abstract class Selection<Q extends Quest> {
        private final String[] lines;

        public Selection(String title, String line1, String line2) {
            this.lines = new String[3];
            this.lines[0] = title;
            this.lines[1] = line1;
            this.lines[2] = line2;
        }

        public Selection(String title, String line1, String line2, String line3) {
            this.lines = new String[4];
            this.lines[0] = title;
            this.lines[1] = line1;
            this.lines[2] = line2;
            this.lines[3] = line3;
        }

        public final String[] getText() {
            return this.lines;
        }

        public abstract Event.Result onSelected(EntityPlayer var1, EntityLiving var2, INPC var3, @Nullable Q var4, int var5);
    }
}

