/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api.knowledge;

import java.util.LinkedHashMap;
import joshie.harvest.api.knowledge.Category;
import joshie.harvest.api.knowledge.NoteRender;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringEscapeUtils;

public class Note {
    public static final LinkedHashMap<ResourceLocation, Note> REGISTRY = new LinkedHashMap();
    private final Category category;
    private final ResourceLocation resource;
    private final String title;
    private final String description;
    private boolean isSecret;
    @SideOnly(value=Side.CLIENT)
    private NoteRender render;

    public Note(Category category, ResourceLocation resource) {
        this.category = category;
        this.resource = resource;
        this.title = resource.func_110624_b() + ".note." + resource.func_110623_a() + ".title";
        this.description = resource.func_110624_b() + ".note." + resource.func_110623_a() + ".description";
        REGISTRY.put(resource, this);
    }

    @SideOnly(value=Side.CLIENT)
    public Note setRender(NoteRender render) {
        this.render = render;
        return this;
    }

    public Note setSecretNote() {
        this.isSecret = true;
        return this;
    }

    public ResourceLocation getResource() {
        return this.resource;
    }

    @SideOnly(value=Side.CLIENT)
    public NoteRender getRender() {
        return this.render;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public String getDescription() {
        return StringEscapeUtils.unescapeJava((String)I18n.func_74838_a((String)this.description));
    }

    public String getTitle() {
        return I18n.func_74838_a((String)this.title);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Note note = (Note)o;
        return this.resource != null ? this.resource.equals((Object)note.resource) : note.resource == null;
    }

    public int hashCode() {
        return this.resource != null ? this.resource.hashCode() : 0;
    }
}

