/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api.crops;

import java.util.List;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.crops.Crop;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GrowthHandler {
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> list, Crop crop, boolean debug) {
        for (Season season : crop.getSeasons()) {
            list.add(season.getDisplayName());
        }
    }

    public boolean canSustainCrop(IBlockAccess world, BlockPos pos, IBlockState state, Crop crop) {
        return state.func_177230_c() instanceof BlockFarmland && crop.getPlantType() == EnumPlantType.Crop;
    }

    public boolean canGrow(World world, BlockPos pos, Crop crop) {
        Season toMatch = HFApi.calendar.getSeasonAtCoordinates(world, pos);
        if (crop.getSeasons() == null) {
            return false;
        }
        for (Season season : crop.getSeasons()) {
            if (toMatch != season) continue;
            return true;
        }
        return false;
    }
}

