/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api.crops;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.AnimalFoodType;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.cooking.Ingredient;
import joshie.harvest.api.core.IShippable;
import joshie.harvest.api.crops.DropHandler;
import joshie.harvest.api.crops.GrowthHandler;
import joshie.harvest.api.crops.IStateHandler;
import joshie.harvest.api.crops.StateHandlerDefault;
import net.minecraft.block.Block;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.RegistryBuilder;
import org.apache.commons.lang3.StringUtils;

public class Crop
extends IForgeRegistryEntry.Impl<Crop>
implements IShippable {
    public static final IForgeRegistry<Crop> REGISTRY = new RegistryBuilder().setName(new ResourceLocation("harvestfestival", "crops")).setType(Crop.class).setIDRange(0, 32000).create();
    public static final GrowthHandler SEASONAL = new GrowthHandler(){};
    public static final DropHandler DROPS = new DropHandler();
    public static final Crop NULL_CROP = new Crop();
    private IStateHandler stateHandler;
    private GrowthHandler growthHandler;
    private DropHandler dropHandler;
    private AnimalFoodType foodType;
    private EnumPlantType type;
    private Ingredient ingredient;
    private Block growsToSide;
    private boolean needsWatering;
    private boolean alternativeName;
    private boolean requiresSickle;
    private int hunger;
    private float saturation;
    private ItemStack item;
    private Season[] seasons;
    private long cost;
    private long sell;
    private int stages;
    private int regrow;
    private int year;
    private int bagColor;
    private int witheredColor;
    private int doubleStage;
    private int minCut;
    private boolean skipRender;

    private Crop() {
        this(new ResourceLocation("harvestfestival", "null_crop"), 0L, 0L, 3, 0xFFFFFF, new Season[0]);
    }

    public Crop(ResourceLocation key, long cost, long sell, int stages, int color, Season ... seasons) {
        this.seasons = seasons;
        this.cost = cost;
        this.sell = sell;
        this.stages = stages;
        this.regrow = 0;
        this.year = 0;
        this.alternativeName = false;
        this.foodType = AnimalFoodType.VEGETABLE;
        this.bagColor = color;
        this.witheredColor = 10898943;
        this.stateHandler = new StateHandlerDefault(this);
        this.growthHandler = SEASONAL;
        this.needsWatering = true;
        this.doubleStage = Integer.MAX_VALUE;
        this.dropHandler = null;
        this.growsToSide = null;
        this.type = EnumPlantType.Crop;
        this.skipRender = false;
        this.setRegistryName(key);
        REGISTRY.register((IForgeRegistryEntry)this);
    }

    public Crop setYearUnlocked(int year) {
        this.year = year;
        return this;
    }

    public Crop setRegrowStage(int regrow) {
        this.regrow = regrow;
        return this;
    }

    public Crop setHasAlternativeName() {
        this.alternativeName = true;
        return this;
    }

    public Crop setItem(ItemStack item) {
        this.item = item;
        if (this.item.func_77973_b() instanceof ItemFood) {
            ItemFood food = (ItemFood)this.item.func_77973_b();
            this.setFoodStats(food.func_150905_g(item), food.func_150906_h(item));
        }
        return this;
    }

    public Crop setStateHandler(IStateHandler handler) {
        this.stateHandler = handler;
        return this;
    }

    public Crop setRequiresSickle(int minCut) {
        this.requiresSickle = true;
        this.minCut = minCut;
        return this;
    }

    public Crop setAnimalFoodType(AnimalFoodType foodType) {
        this.foodType = foodType;
        return this;
    }

    public Crop setPlantType(EnumPlantType plantType) {
        this.type = plantType;
        return this;
    }

    public Crop setFoodStats(int hunger, float saturation) {
        this.hunger = hunger;
        this.saturation = saturation;
        String name = this.getRegistryName().func_110623_a();
        this.ingredient = Ingredient.INGREDIENTS.containsKey(name) ? Ingredient.INGREDIENTS.get(name) : new Ingredient(name, hunger, saturation);
        return this;
    }

    public Crop setIngredient(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public Crop setNoWaterRequirements() {
        this.needsWatering = false;
        return this;
    }

    public Crop setGrowthHandler(GrowthHandler handler) {
        this.growthHandler = handler;
        return this;
    }

    public Crop setBecomesDouble(int doubleStage) {
        this.doubleStage = doubleStage;
        return this;
    }

    public Crop setDropHandler(DropHandler handler) {
        this.dropHandler = handler;
        return this;
    }

    public Crop setGrowsToSide(Block block) {
        this.growsToSide = block;
        return this;
    }

    public Crop setWitheredColor(int color) {
        this.witheredColor = color;
        return this;
    }

    public Crop setSkipRender() {
        this.skipRender = true;
        return this;
    }

    public boolean hasItemAssigned() {
        return this.item != null;
    }

    public Season[] getSeasons() {
        return this.seasons;
    }

    public long getSeedCost() {
        return this.cost;
    }

    @Override
    public long getSellValue(ItemStack stack) {
        return this.sell;
    }

    public int getStages() {
        return this.stages;
    }

    public int getPurchaseYear() {
        return this.year;
    }

    public int getRegrowStage() {
        return this.regrow;
    }

    public int getMinimumCut() {
        return this.minCut;
    }

    public boolean requiresSickle() {
        return this.requiresSickle;
    }

    public boolean requiresWater() {
        return this.needsWatering;
    }

    public boolean isTurningToDouble(int stage) {
        return stage == this.doubleStage;
    }

    public boolean isCurrentlyDouble(int stage) {
        return stage >= this.doubleStage;
    }

    public Block growsToSide() {
        return this.growsToSide;
    }

    public GrowthHandler getGrowthHandler() {
        return this.growthHandler;
    }

    public boolean canPurchase() {
        return this.getSeedCost() > 0L;
    }

    public int getColor() {
        return this.bagColor;
    }

    public int getWitheredColor() {
        return this.witheredColor;
    }

    public AnimalFoodType getFoodType() {
        return this.foodType;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public ItemStack getSeedStack(int amount) {
        return HFApi.crops.getSeedStack(this, amount);
    }

    public ItemStack getCropStack(int amount) {
        if (this.item != null) {
            ItemStack copy = this.item.func_77946_l();
            copy.field_77994_a = amount;
            return this.item.func_77946_l();
        }
        return HFApi.crops.getCropStack(this, amount);
    }

    public DropHandler getDropHandler() {
        return this.dropHandler == null ? DROPS : this.dropHandler;
    }

    public IStateHandler getStateHandler() {
        return this.stateHandler;
    }

    public boolean matches(ItemStack stack) {
        return HFApi.crops.getCropFromStack(stack) == this;
    }

    public EnumPlantType getPlantType() {
        return this.type;
    }

    public boolean skipLoadingRender() {
        return this.skipRender;
    }

    public String getLocalizedName(boolean isItem) {
        String suffix = this.alternativeName ? (isItem ? ".item" : ".block") : "";
        return I18n.func_74838_a((String)(this.getRegistryName().func_110624_b() + ".crop." + StringUtils.replace((String)this.getRegistryName().func_110623_a(), (String)"_", (String)".") + suffix));
    }

    public String getSeedsName() {
        String suffix = this.alternativeName ? ".block" : "";
        String name = I18n.func_74837_a((String)(this.getRegistryName().func_110624_b() + ".crop." + StringUtils.replace((String)this.getRegistryName().func_110623_a(), (String)"_", (String)".") + suffix), (Object[])new Object[0]);
        String seeds = I18n.func_74838_a((String)"harvestfestival.crop.seeds");
        String format = I18n.func_74838_a((String)"harvestfestival.crop.seeds.format");
        return String.format(format, name, seeds);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Crop && this.getRegistryName().equals((Object)((Crop)o).getRegistryName());
    }

    public int hashCode() {
        return this.getRegistryName().hashCode();
    }
}

