/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api.cooking;

import java.util.Locale;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Utensil {
    public static Utensil[] UTENSILS = new Utensil[5];
    public static final Utensil COUNTER = new Utensil(0, "counter");
    public static final Utensil POT = new Utensil(1, "pot");
    public static final Utensil FRYING_PAN = new Utensil(2, "frying_pan");
    public static final Utensil MIXER = new Utensil(3, "mixer");
    public static final Utensil OVEN = new Utensil(4, "oven");
    private final String label;
    private final int index;

    public Utensil(String label) {
        this(Utensil.getNextID(), label);
    }

    private Utensil(int index, String label) {
        if (index >= UTENSILS.length) {
            Utensil[] tmp = new Utensil[index + 1];
            for (int x = 0; x < UTENSILS.length; ++x) {
                tmp[x] = UTENSILS[x];
            }
            UTENSILS = tmp;
        }
        this.label = label;
        this.index = index;
        Utensil.UTENSILS[index] = this;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelForMeal() {
        return new ModelResourceLocation(new ResourceLocation("harvestfestival", "meals/burnt_" + this.label), "inventory");
    }

    public String getUnlocalizedName() {
        return "harvestfestival.meal.burnt." + this.label.replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    public final int getIndex() {
        return this.index;
    }

    public static Utensil getUtensilFromIndex(int index) {
        return UTENSILS[Math.max(0, Math.min(UTENSILS.length - 1, index))];
    }

    private static int getNextID() {
        return CreativeTabs.field_78032_a.length;
    }
}

