/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api.cooking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import joshie.harvest.api.cooking.Ingredient;
import joshie.harvest.api.cooking.IngredientStack;
import joshie.harvest.api.cooking.Meal;
import joshie.harvest.api.cooking.Utensil;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.RegistryBuilder;

public class Recipe
extends IForgeRegistryEntry.Impl<Recipe>
implements Meal {
    public static final IForgeRegistry<Recipe> REGISTRY = new RegistryBuilder().setName(new ResourceLocation("harvestfestival", "meals")).setType(Recipe.class).setIDRange(0, 32000).create();
    private final List<IngredientStack> required = new ArrayList<IngredientStack>();
    private List<IngredientStack> optional = new ArrayList<IngredientStack>();
    private final Utensil utensil;
    private int hunger;
    private float saturation;
    private EnumAction action;
    private int eatTimer;
    private int maximumOptional;
    private boolean isLearntByDefault;

    public Recipe(Utensil utensil, IngredientStack ... required) {
        this.utensil = utensil;
        this.action = EnumAction.EAT;
        this.eatTimer = 24;
        this.maximumOptional = 20;
        Collections.addAll(this.required, required);
    }

    public void setDefault() {
        this.isLearntByDefault = true;
    }

    public Recipe setFoodStats(int hunger, float saturation) {
        this.hunger = hunger;
        this.saturation = saturation;
        return this;
    }

    public Recipe setRequiredIngredients(IngredientStack ... required) {
        Collections.addAll(this.required, required);
        return this;
    }

    @Override
    public Recipe setOptionalIngredients(Ingredient ... ingredients) {
        for (Ingredient ingredient : ingredients) {
            this.optional.add(new IngredientStack(ingredient));
        }
        return this;
    }

    public Recipe setOptionalIngredients(IngredientStack ... ingredients) {
        Collections.addAll(this.optional, ingredients);
        return this;
    }

    @Override
    public Recipe setIsDrink() {
        this.action = EnumAction.DRINK;
        return this;
    }

    public Recipe setEatTimer(int eatTimer) {
        this.eatTimer = eatTimer;
        return this;
    }

    public Recipe setMaximumOptionalIngredients(int maximum) {
        this.maximumOptional = maximum;
        return this;
    }

    @Override
    public Meal setAlternativeTexture(ItemStack stack) {
        return this;
    }

    @Override
    public Meal setExhaustion(float exhaustion) {
        return this;
    }

    public String getDisplayName() {
        return I18n.func_74838_a((String)(this.getRegistryName().func_110624_b() + ".meal." + this.getRegistryName().func_110623_a().replace("_", ".")));
    }

    public boolean isDefault() {
        return this.isLearntByDefault;
    }

    public List<IngredientStack> getRequired() {
        return this.required;
    }

    public List<IngredientStack> getOptional() {
        return this.optional;
    }

    public int getMaximumOptionalIngredients() {
        return this.maximumOptional;
    }

    public Utensil getUtensil() {
        return this.utensil;
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public EnumAction getAction() {
        return this.action;
    }

    public int getEatTimer() {
        return this.eatTimer;
    }

    public ItemStack getStack() {
        return new ItemStack(Items.field_151105_aU);
    }

    public boolean supportsNBTData() {
        return true;
    }
}

