/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api.cooking;

import java.util.Collection;
import joshie.harvest.api.cooking.Ingredient;

public final class IngredientStack {
    private final Ingredient ingredient;
    private final int stackSize;

    public IngredientStack(Ingredient ingredient) {
        this(ingredient, 1);
    }

    public IngredientStack(Ingredient ingredient, int stackSize) {
        this.ingredient = ingredient;
        this.stackSize = stackSize;
        if (ingredient == null) {
            throw new NullPointerException("Attempted to add a null ingredient to an ingredient stack");
        }
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public boolean isSame(IngredientStack stack) {
        for (Ingredient ingredient : this.getIngredient().getEquivalents()) {
            if (stack.getIngredient() != ingredient) continue;
            return true;
        }
        return false;
    }

    public boolean isSame(Collection<IngredientStack> stacks) {
        int count = 0;
        for (IngredientStack stack : stacks) {
            if (!this.isSame(stack)) continue;
            ++count;
        }
        return count >= this.stackSize;
    }
}

