/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api.cooking;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public final class Ingredient {
    public static final Map<String, Ingredient> INGREDIENTS = new HashMap<String, Ingredient>();
    private final HashSet<Ingredient> equivalents = new HashSet();
    private final String unlocalized;
    private int hunger;
    private float saturation;
    private float exhaustion;
    private int eatTime;
    public ResourceLocation fluid;

    public Ingredient(String unlocalized, int hunger, float saturation) {
        this.unlocalized = unlocalized;
        this.hunger = hunger;
        this.saturation = saturation;
        this.exhaustion = 0.0f;
        this.eatTime = 4;
        this.equivalents.add(this);
        INGREDIENTS.put(unlocalized, this);
    }

    public Ingredient(String unlocalized) {
        this.unlocalized = unlocalized;
        this.equivalents.add(this);
        INGREDIENTS.put(unlocalized, this);
    }

    public Ingredient add(Ingredient ... ingredients) {
        this.equivalents.addAll(Arrays.asList(ingredients));
        return this;
    }

    public Ingredient setFluid(ResourceLocation fluid) {
        this.fluid = fluid;
        return this;
    }

    public Ingredient setExhaustion(float exhaustion) {
        this.exhaustion = exhaustion;
        return this;
    }

    public Ingredient setEatTime(int eatTime) {
        this.eatTime = eatTime;
        return this;
    }

    public ResourceLocation getFluid() {
        return this.fluid;
    }

    public String getUnlocalized() {
        return this.unlocalized;
    }

    public int getEatTime() {
        return this.eatTime;
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public float getExhaustion() {
        return this.exhaustion;
    }

    public boolean isEqual(Ingredient ingredient) {
        for (Ingredient i : this.equivalents) {
            if (!i.getUnlocalized().equals(ingredient.getUnlocalized())) continue;
            return true;
        }
        return false;
    }
}

