/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api.calendar;

import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.calendar.Weekday;
import net.minecraft.nbt.NBTTagCompound;

public class CalendarDate {
    public static int DAYS_PER_SEASON = 30;
    private Weekday weekday;
    private int day;
    private Season season;
    private int year;

    public CalendarDate() {
    }

    public CalendarDate(int day, Season season, int year) {
        this.day = day;
        this.season = season;
        this.year = year;
        this.weekday = Weekday.MONDAY;
    }

    private CalendarDate(CalendarDate date) {
        this.weekday = date.getWeekday();
        this.day = date.getDay();
        this.season = date.getSeason();
        this.year = date.getYear();
    }

    public boolean isSameDay(CalendarDate date) {
        int day = (int)Math.ceil(date.getDay() / DAYS_PER_SEASON * 30);
        return day == this.getDay() && date.getSeason() == this.getSeason();
    }

    public CalendarDate copy() {
        return new CalendarDate(this);
    }

    public CalendarDate setWeekday(Weekday weekday) {
        this.weekday = weekday;
        return this;
    }

    public CalendarDate setDay(int day) {
        this.day = day;
        return this;
    }

    public CalendarDate setSeason(Season season) {
        this.season = season;
        return this;
    }

    public CalendarDate setYear(int year) {
        this.year = year;
        return this;
    }

    public Weekday getWeekday() {
        return this.weekday;
    }

    public int getDay() {
        return this.day;
    }

    public Season getSeason() {
        return this.season;
    }

    public int getYear() {
        return this.year;
    }

    public static CalendarDate fromNBT(NBTTagCompound nbt) {
        Weekday weekday = Weekday.values()[nbt.func_74771_c("WeekDay")];
        int day = nbt.func_74762_e("Day");
        Season season = Season.values()[nbt.func_74771_c("Season")];
        int year = nbt.func_74762_e("Year");
        return new CalendarDate(day, season, year).setWeekday(weekday);
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("WeekDay", (byte)this.weekday.ordinal());
        nbt.func_74768_a("Day", this.day);
        nbt.func_74774_a("Season", (byte)this.season.ordinal());
        nbt.func_74768_a("Year", this.year);
        return nbt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarDate that = (CalendarDate)o;
        if (this.day != that.day) {
            return false;
        }
        if (this.year != that.year) {
            return false;
        }
        return this.season == that.season;
    }

    public int hashCode() {
        int result = this.day;
        result = 31 * result + (this.season != null ? this.season.hashCode() : 0);
        result = 31 * result + this.year;
        return result;
    }
}

