/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api.buildings;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.buildings.Building;
import net.minecraft.util.ResourceLocation;

public class BuildingLocation {
    private final ResourceLocation building;
    private final String location;
    private final double distance;
    private final long time;

    public BuildingLocation(Building building, String location) {
        this.building = HFApi.buildings.getNameForBuilding(building);
        this.location = location;
        this.distance = 5.0;
        this.time = 500L;
    }

    private BuildingLocation(BuildingLocation location, double distance) {
        this.building = location.building;
        this.location = location.location;
        this.distance = distance;
        this.time = location.time;
    }

    private BuildingLocation(BuildingLocation location, long time) {
        this.building = location.building;
        this.location = location.location;
        this.distance = location.distance;
        this.time = time;
    }

    public BuildingLocation withDistance(double distance) {
        if (this.distance == distance) {
            return this;
        }
        return new BuildingLocation(this, distance);
    }

    public BuildingLocation withTime(long time) {
        if (this.time == time) {
            return this;
        }
        return new BuildingLocation(this, time);
    }

    public double getDistanceRequired() {
        return this.distance;
    }

    public long getTimeToTry() {
        return this.time;
    }

    public ResourceLocation getResource() {
        return this.building;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildingLocation that = (BuildingLocation)o;
        if (this.building != null ? !this.building.equals((Object)that.building) : that.building != null) {
            return false;
        }
        return this.location != null ? this.location.equals(that.location) : that.location == null;
    }

    public int hashCode() {
        int result = this.building != null ? this.building.hashCode() : 0;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        return result;
    }
}

