/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.api;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class WorldLocation {
    public int dimension;
    public BlockPos position;

    public WorldLocation() {
    }

    public WorldLocation(int dimension, BlockPos position) {
        this.dimension = dimension;
        this.position = position;
    }

    public WorldLocation(WorldLocation location) {
        this.dimension = location.dimension;
        this.position = new BlockPos((Vec3i)location.position);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimension;
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorldLocation other = (WorldLocation)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        return !(this.position == null ? other.position != null : !this.position.equals((Object)other.position));
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.dimension = tag.func_74764_b("Dimension") ? (int)tag.func_74771_c("Dimension") : 0;
        int x = tag.func_74762_e("X");
        int y = tag.func_74762_e("Y");
        int z = tag.func_74762_e("Z");
        this.position = new BlockPos(x, y, z);
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (this.dimension != 0) {
            tag.func_74774_a("Dimension", (byte)this.dimension);
        }
        tag.func_74768_a("X", this.position.func_177958_n());
        tag.func_74768_a("Y", this.position.func_177956_o());
        tag.func_74768_a("Z", this.position.func_177952_p());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.dimension);
        buf.writeInt(this.position.func_177958_n());
        buf.writeInt(this.position.func_177956_o());
        buf.writeInt(this.position.func_177952_p());
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readByte();
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.position = new BlockPos(x, y, z);
    }
}

