/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals.tracker;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import joshie.harvest.animals.tracker.AnimalTracker;
import joshie.harvest.api.animals.AnimalStats;
import joshie.harvest.core.HFTrackers;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.player.PlayerTracker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class AnimalTrackerServer
extends AnimalTracker {
    private static final DamageSource natural_causes = new DamageSource("natural").func_76348_h();
    private final HashMap<EntityAnimal, AnimalStats> animals = new HashMap();
    private static final Set<Runnable> queue = new HashSet<Runnable>();

    public static void addToQueue(Runnable r) {
        queue.add(r);
    }

    public static void processQueue() {
        HashSet<Runnable> toProcess = new HashSet<Runnable>(queue);
        queue.clear();
        toProcess.forEach(Runnable::run);
    }

    @Override
    public void onDeath(AnimalStats stats) {
        stats.setDead();
    }

    public void onJoinWorld(EntityAnimal entity, AnimalStats animal) {
        this.animals.put(entity, animal);
    }

    public void biHourly() {
        try {
            for (AnimalStats stats : this.animals.values()) {
                stats.onBihourlyTick();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void newDay() {
        World world = this.getWorld();
        Iterator<Map.Entry<EntityAnimal, AnimalStats>> iterator = this.animals.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<EntityAnimal, AnimalStats> data = iterator.next();
            EntityAnimal animal = data.getKey();
            if (!world.field_72996_f.contains(animal) || animal != null && !animal.field_70128_L && data.getValue().newDay()) continue;
            iterator.remove();
            if (animal == null || animal.field_70128_L) continue;
            animal.func_70097_a(natural_causes, 1000.0f);
            for (PlayerTracker playerTracker : HFTrackers.getPlayerTrackers()) {
                playerTracker.getRelationships().clear(EntityHelper.getEntityUUID((Entity)animal));
            }
        }
    }
}

