/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals.tile;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.AnimalFoodType;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.api.ticking.IDailyTickable;
import joshie.harvest.core.base.tile.TileFillable;
import joshie.harvest.core.helpers.EntityHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileTrough
extends TileFillable {
    private static final int MAX_WIDTH = 3;
    private boolean facingX;
    private int offsetX;
    private int offsetZ;
    private int size;

    public TileTrough getMaster() {
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(this.offsetX, 0, this.offsetZ));
        return tile instanceof TileTrough ? (TileTrough)tile : this;
    }

    public int getSize() {
        return this.size;
    }

    private boolean updateMasterInDirection(EnumFacing facing) {
        TileTrough trough;
        if (this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing)) instanceof TileTrough && (trough = ((TileTrough)this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing))).getMaster()).getSize() < 3) {
            int offsetX = trough.func_174877_v().func_177958_n() - this.func_174877_v().func_177958_n();
            int offsetZ = trough.func_174877_v().func_177952_p() - this.func_174877_v().func_177952_p();
            if (offsetX != 0 && offsetZ != 0) {
                return false;
            }
            if (trough.size > 1) {
                if (trough.facingX && offsetX != 0) {
                    return false;
                }
                if (!trough.facingX && offsetZ != 0) {
                    return false;
                }
            }
            if (offsetZ != 0) {
                trough.facingX = true;
            }
            if (offsetX != 0) {
                trough.facingX = false;
            }
            this.offsetX = offsetX;
            this.offsetZ = offsetZ;
            ++trough.size;
            trough.func_70296_d();
            return true;
        }
        return false;
    }

    private void updateMaster() {
        if (this.updateMasterInDirection(EnumFacing.NORTH)) {
            return;
        }
        if (this.updateMasterInDirection(EnumFacing.SOUTH)) {
            return;
        }
        if (this.updateMasterInDirection(EnumFacing.EAST)) {
            return;
        }
        if (!this.updateMasterInDirection(EnumFacing.WEST)) {
            this.offsetX = 0;
            this.offsetZ = 0;
            this.size = 1;
            this.func_70296_d();
        }
    }

    public void onPlaced() {
        this.updateMaster();
        this.setFilled(this.getFillAmount());
    }

    private BlockPos getNewMaster() {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(x, 0, z));
                if (!(tile instanceof TileTrough) || ((TileTrough)tile).getMaster() != this) continue;
                return this.func_174877_v().func_177982_a(x, 0, z);
            }
        }
        return null;
    }

    private void setMaster(BlockPos pos) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                TileTrough trough;
                TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(x, 0, z));
                if (!(tile instanceof TileTrough) || (trough = (TileTrough)tile).getMaster() != this) continue;
                trough.offsetX = pos.func_177958_n() - trough.func_174877_v().func_177958_n();
                trough.offsetZ = pos.func_177952_p() - trough.func_174877_v().func_177952_p();
                trough.updateMaster();
                trough.func_70296_d();
            }
        }
    }

    public void onRemoved() {
        BlockPos newMaster;
        int volume = this.getMaster().getFillAmount();
        int size = Math.max(0, this.getMaster().size - 1);
        boolean facingX = this.getMaster().facingX;
        TileTrough master = this.getMaster();
        if (this.getMaster() == this && (newMaster = this.getNewMaster()) != null) {
            this.setMaster(newMaster);
        }
        master.setFilled(Math.min(7 * size, volume));
        master.size = size;
        master.facingX = facingX;
        master.func_70296_d();
    }

    @Override
    public boolean onActivated(ItemStack held) {
        TileTrough master;
        if (HFApi.animals.canEat(held, AnimalFoodType.GRASS) && (master = this.getMaster()) != null) {
            boolean processed = false;
            for (int i = 0; i < 6 && held.field_77994_a > 0; ++i) {
                if (held.field_77994_a < 1) continue;
                if (!master.hasRoomAndFill()) break;
                held.func_77979_a(1);
                processed = true;
            }
            return processed;
        }
        return false;
    }

    private boolean hasRoomAndFill() {
        if (this.fillAmount < 4 * this.size) {
            this.setFilled(this.getFillAmount() + 1);
            return true;
        }
        return false;
    }

    private boolean hasFoodAndFeed() {
        if (this.fillAmount > 0) {
            this.setFilled(this.getFillAmount() - 1);
            return true;
        }
        return false;
    }

    @Override
    public void newDay(IDailyTickable.Phase phase) {
        if (this.getMaster() == this) {
            for (EntityAnimal animal : EntityHelper.getEntities(EntityAnimal.class, this.func_145831_w(), this.func_174877_v(), 16.0, 5.0)) {
                IAnimalTracked tracked;
                if (!(animal instanceof IAnimalTracked) || !(tracked = (IAnimalTracked)animal).getData().isHungry() || !HFApi.animals.canAnimalEatFoodType(tracked, AnimalFoodType.GRASS) || !this.hasFoodAndFeed()) continue;
                tracked.getData().feed(null);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.facingX = nbt.func_74767_n("FacingX");
        this.offsetX = nbt.func_74762_e("OffsetX");
        this.offsetZ = nbt.func_74762_e("OffsetZ");
        this.size = nbt.func_74771_c("Size");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("FacingX", this.facingX);
        nbt.func_74768_a("OffsetX", this.offsetX);
        nbt.func_74768_a("OffsetZ", this.offsetZ);
        nbt.func_74774_a("Size", (byte)this.size);
        return super.func_189515_b(nbt);
    }
}

