/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals.tile;

import java.util.UUID;
import joshie.harvest.animals.HFAnimals;
import joshie.harvest.animals.entity.EntityHarvestChicken;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.api.ticking.IDailyTickable;
import joshie.harvest.core.base.tile.TileFillableSizedFaceable;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.helpers.MCServerHelper;
import joshie.harvest.player.PlayerTracker;
import joshie.harvest.tools.ToolHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileIncubator
extends TileFillableSizedFaceable {
    private static final int MAX_FILL = 7;
    private UUID owner;
    private int relationship;

    @Override
    public boolean onActivated(EntityPlayer player, ItemStack held) {
        if (ToolHelper.isEgg(held) && this.fillAmount == 0) {
            this.setFilled(HFApi.sizeable.getSize(held), 7);
            NBTTagCompound tag = held.func_179543_a("Data", true);
            this.relationship = tag.func_74762_e("Relationship");
            this.owner = tag.func_74764_b("Owner") ? UUID.fromString(tag.func_74779_i("Owner")) : EntityHelper.getPlayerUUID(player);
            held.func_77979_a(1);
            return true;
        }
        return false;
    }

    @Override
    public void newDay(IDailyTickable.Phase phase) {
        if (phase == IDailyTickable.Phase.PRE && this.fillAmount > 0 && this.owner != null) {
            --this.fillAmount;
            if (this.fillAmount == 0) {
                int amount = 1;
                if (this.size == ISizeable.Size.MEDIUM && this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                    ++amount;
                }
                if (this.size == ISizeable.Size.LARGE && this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                    ++amount;
                }
                if (this.size == ISizeable.Size.LARGE && this.field_145850_b.field_73012_v.nextInt(50) == 0) {
                    ++amount;
                }
                for (int i = 0; i < amount; ++i) {
                    EntityHarvestChicken baby = new EntityHarvestChicken(this.field_145850_b);
                    baby.func_70634_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177984_a().func_177956_o() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177952_p() + 0.5);
                    baby.func_70873_a(-(24000 * HFAnimals.AGING_TIMER));
                    baby.getData().setOwner(this.owner);
                    ((PlayerTracker)HFTrackers.getPlayerTracker(this.field_145850_b, this.owner)).getRelationships().copyRelationship((EntityPlayer)EntityHelper.getPlayerFromUUID(this.owner), this.relationship, EntityHelper.getEntityUUID((Entity)baby), 50.0);
                    this.field_145850_b.func_72838_d((Entity)baby);
                }
                this.owner = null;
            }
            MCServerHelper.markTileForUpdate(this);
            this.func_70296_d();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.relationship = nbt.func_74762_e("Relationship");
        if (nbt.func_74764_b("Owner")) {
            this.owner = UUID.fromString(nbt.func_74779_i("Owner"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("Relationship", this.relationship);
        if (this.owner != null) {
            nbt.func_74778_a("Owner", this.owner.toString());
        }
        return super.func_189515_b(nbt);
    }
}

