/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals.stats;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joshie.harvest.animals.HFAnimals;
import joshie.harvest.animals.stats.AnimalStatsHF;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.AnimalAction;
import joshie.harvest.api.animals.AnimalStats;
import joshie.harvest.api.animals.AnimalTest;
import joshie.harvest.api.animals.IAnimalHandler;
import joshie.harvest.calendar.HFCalendar;
import joshie.harvest.core.HFTrackers;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.player.PlayerTracker;
import joshie.harvest.player.PlayerTrackerServer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class AnimalStatsLivestock
extends AnimalStatsHF {
    private int cleanliness = 0;
    private boolean isPregnant;
    private int daysPregnant;

    public AnimalStatsLivestock() {
        this.type = HFAnimals.SHEEP;
    }

    @Override
    protected void preStress() {
        --this.cleanliness;
    }

    @Override
    protected void postStress() {
        if (this.cleanliness < 0) {
            this.healthiness += this.cleanliness;
        } else if (this.cleanliness >= 0) {
            this.cleanliness = 0;
        }
    }

    @Override
    protected void updateStats() {
        super.updateStats();
        if (this.isPregnant) {
            ++this.daysPregnant;
        }
    }

    @Override
    protected void updatePregnancy() {
        if (this.isPregnant) {
            ++this.daysPregnant;
            if (this.daysPregnant >= HFAnimals.PREGNANCY_TIMER) {
                this.isPregnant = false;
                this.daysPregnant = 0;
                this.giveBirth();
            }
        }
        if (this.animal.func_70631_g_()) {
            this.animal.func_110195_a(1200);
        }
    }

    @Override
    public boolean performTest(AnimalTest test) {
        if (test == AnimalTest.CAN_CLEAN) {
            return true;
        }
        if (test == AnimalTest.IS_CLEAN) {
            return this.cleanliness == 127;
        }
        return super.performTest(test);
    }

    @Override
    public boolean performAction(@Nonnull World world, @Nullable EntityPlayer player, @Nullable ItemStack stack, AnimalAction action) {
        if (action == AnimalAction.CLEAN) {
            return this.clean(world, player);
        }
        if (action == AnimalAction.IMPREGNATE) {
            return this.impregnate(player);
        }
        return super.performAction(world, player, stack, action);
    }

    private boolean clean(@Nonnull World world, @Nullable EntityPlayer player) {
        if (this.cleanliness < 127) {
            if (!world.field_72995_K) {
                this.cleanliness = (byte)Math.min(127, this.cleanliness + 10);
                if (this.cleanliness >= 127) {
                    this.affectRelationship(player, 30);
                    HFApi.animals.syncAnimalStats(this.animal);
                }
            }
            return true;
        }
        return false;
    }

    private boolean impregnate(EntityPlayer player) {
        if (this.animal.func_70654_ax() < 0) {
            return false;
        }
        if (this.isPregnant) {
            return false;
        }
        this.daysPregnant = 0;
        this.isPregnant = true;
        this.affectRelationship(player, 200);
        HFApi.animals.syncAnimalStats(this.animal);
        return true;
    }

    private void giveBirth() {
        int i;
        int count = 1;
        for (i = 0; i < HFAnimals.MAX_LITTER_SIZE - 1; ++i) {
            if (!(rand.nextDouble() * 100.0 <= (double)HFAnimals.LITTER_EXTRA_CHANCE)) continue;
            ++count;
        }
        for (i = 0; i < count; ++i) {
            EntityAgeable baby = this.animal.func_90011_a((EntityAgeable)this.animal);
            baby.func_70873_a(-((int)(HFCalendar.TICKS_PER_DAY * (long)HFAnimals.AGING_TIMER)));
            baby.func_70012_b(this.animal.field_70165_t, this.animal.field_70163_u, this.animal.field_70161_v, 0.0f, 0.0f);
            ((AnimalStats)baby.getCapability(IAnimalHandler.ANIMAL_STATS_CAPABILITY, EnumFacing.DOWN)).setOwner(this.o_uuid);
            int parent = ((PlayerTrackerServer)HFTrackers.getPlayerTracker(this.animal.field_70170_p, this.o_uuid)).getRelationships().getRelationship(EntityHelper.getEntityUUID((Entity)this.animal));
            ((PlayerTracker)HFTrackers.getPlayerTracker(this.animal.field_70170_p, this.o_uuid)).getRelationships().copyRelationship(this.getOwner(), parent, EntityHelper.getEntityUUID((Entity)baby), 50.0);
        }
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.cleanliness = nbt.func_74771_c("Cleanliness");
        this.isPregnant = nbt.func_74767_n("IsPregnant");
        this.daysPregnant = nbt.func_74771_c("DaysPregnant");
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74774_a("Cleanliness", (byte)this.cleanliness);
        tag.func_74757_a("IsPregnant", this.isPregnant);
        tag.func_74774_a("DaysPregnant", (byte)this.daysPregnant);
        return tag;
    }
}

