/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals.stats;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joshie.harvest.animals.HFAnimals;
import joshie.harvest.animals.item.ItemAnimalTreat;
import joshie.harvest.animals.packet.PacketSyncAnimal;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.AnimalAction;
import joshie.harvest.api.animals.AnimalStats;
import joshie.harvest.api.animals.AnimalTest;
import joshie.harvest.api.animals.IAnimalType;
import joshie.harvest.api.player.RelationshipType;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.network.PacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class AnimalStatsHF
implements AnimalStats<NBTTagCompound> {
    protected static final Random rand = new Random();
    private WeakReference<EntityPlayer> owner;
    protected EntityAnimal animal;
    protected IAnimalType type = HFAnimals.CHICKENS;
    protected UUID o_uuid;
    private int currentLifespan = 0;
    protected int healthiness = 127;
    private int stress = -128;
    private int daysNotFed;
    private boolean isSick;
    private boolean wasSick;
    private boolean hasDied;
    private int daysPassed;
    private int productsPerDay = 1;
    private int producedProducts;
    private boolean treated;
    private int genericTreats;
    private int typeTreats;
    private boolean wasOutsideInSun;

    public AnimalStatsHF setType(IAnimalType type) {
        this.type = type;
        return this;
    }

    @Override
    public AnimalStatsHF setEntity(EntityAnimal animal) {
        this.animal = animal;
        return this;
    }

    @Override
    public IAnimalType getType() {
        return this.type;
    }

    @Override
    public EntityAnimal getAnimal() {
        return this.animal;
    }

    private int getDeathChance() {
        EntityPlayer owner = this.getOwner();
        if (owner == null) {
            return Integer.MAX_VALUE;
        }
        if (this.daysNotFed > 0) {
            return Math.max(1, 45 - this.daysNotFed * 3);
        }
        int relationship = HFApi.player.getRelationsForPlayer(owner).getRelationship(EntityHelper.getEntityUUID((Entity)this.animal));
        double chance = (double)relationship / (double)RelationshipType.ANIMAL.getMaximumRP() * 200.0;
        if ((chance += (double)this.healthiness) <= 1.0) {
            chance = 1.0;
        }
        return (int)chance;
    }

    @Override
    public void setDead() {
        this.hasDied = true;
    }

    @Override
    public int getProductsPerDay() {
        return this.productsPerDay;
    }

    @Override
    public void onBihourlyTick() {
        World world = this.animal.field_70170_p;
        boolean dayTime = world.func_72935_r();
        boolean isRaining = world.func_72896_J();
        boolean isOutside = world.func_175710_j(new BlockPos((Entity)this.animal));
        if ((isRaining || !dayTime) && isOutside) {
            this.stress = (byte)Math.min(127, this.stress + 10);
        } else if (this.stress > -128) {
            --this.stress;
        }
        if (this.stress > 0) {
            --this.healthiness;
        }
        boolean isOutsideInSun = !isRaining && isOutside && dayTime;
        EntityPlayer owner = this.getOwner();
        if (owner != null && isOutsideInSun && this.wasOutsideInSun) {
            ++this.healthiness;
            this.affectRelationship(owner, this.type.getRelationshipBonus(AnimalAction.OUTSIDE));
        }
        this.wasOutsideInSun = isOutsideInSun;
    }

    protected void preStress() {
    }

    protected void postStress() {
    }

    protected void updateStats() {
        this.treated = false;
    }

    protected void updatePregnancy() {
    }

    @Override
    public boolean newDay() {
        if (this.animal != null) {
            int daysBetween;
            if (this.hasDied) {
                return false;
            }
            if (this.currentLifespan > this.type.getMaxLifespan()) {
                return false;
            }
            if (this.currentLifespan > this.type.getMinLifespan() && rand.nextInt(this.getDeathChance()) == 0) {
                this.hasDied = true;
                return false;
            }
            if (!this.isSick && this.healthiness < 0) {
                this.isSick = true;
            }
            ++this.currentLifespan;
            int originalHealth = this.healthiness;
            this.healthiness -= this.daysNotFed;
            this.preStress();
            if (!HFAnimals.OUTDOOR_HAPPINESS) {
                World world = this.animal.field_70170_p;
                boolean isOutside = world.func_175710_j(new BlockPos((Entity)this.animal));
                boolean isRaining = world.func_72896_J();
                if (isRaining && isOutside) {
                    this.stress = (byte)Math.min(127, this.stress + 50);
                } else if (this.stress > -128) {
                    --this.stress;
                }
                if (this.stress > 0) {
                    --this.healthiness;
                }
            }
            this.postStress();
            if (this.healthiness == originalHealth) {
                this.healthiness += 10;
            }
            this.healthiness = Math.min(127, Math.max(-128, this.healthiness));
            ++this.daysNotFed;
            ++this.daysPassed;
            this.updateStats();
            if (this.isSick) {
                if (!this.wasSick) {
                    this.wasSick = true;
                    this.animal.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 1000000, 0));
                    this.animal.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 1000000, 0));
                    this.animal.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 1000000, 0));
                }
            } else if (this.wasSick) {
                this.wasSick = false;
                this.animal.func_184589_d(MobEffects.field_76431_k);
                this.animal.func_184589_d(MobEffects.field_76440_q);
                this.animal.func_184589_d(MobEffects.field_76421_d);
            }
            if (this.treated && this.productsPerDay < 5) {
                int requiredGeneric = this.type.getGenericTreatCount();
                int requiredType = this.type.getTypeTreatCount();
                if (this.genericTreats >= requiredGeneric && requiredType >= this.typeTreats) {
                    this.genericTreats -= requiredGeneric;
                    this.typeTreats -= requiredType;
                    ++this.productsPerDay;
                }
            }
            if ((daysBetween = this.type.getDaysBetweenProduction()) > 0 && this.daysPassed >= daysBetween) {
                this.daysPassed = 0;
                this.producedProducts = 0;
                this.type.refreshProduct(this, this.animal);
            }
            this.updatePregnancy();
            PacketHandler.sendToEveryone(new PacketSyncAnimal(this.animal.func_145782_y(), this));
            return true;
        }
        return false;
    }

    private EntityPlayer getAndCreateOwner() {
        if (this.owner != null) {
            return (EntityPlayer)this.owner.get();
        }
        if (this.o_uuid != null) {
            this.owner = new WeakReference<EntityPlayerMP>(EntityHelper.getPlayerFromUUID(this.o_uuid));
            return (EntityPlayer)this.owner.get();
        }
        return null;
    }

    @Override
    public EntityPlayer getOwner() {
        EntityPlayer owner = this.getAndCreateOwner();
        if (owner != null && this.animal != null && this.animal.field_70170_p.field_73011_w.getDimension() == owner.field_70170_p.field_73011_w.getDimension() && (double)this.animal.func_70032_d((Entity)owner) <= 178.0) {
            return owner;
        }
        return null;
    }

    @Override
    public void setOwner(@Nonnull UUID uuid) {
        this.o_uuid = uuid;
    }

    @Override
    public boolean canProduce() {
        return this.healthiness > 0 && this.producedProducts < this.productsPerDay;
    }

    @Override
    public void setProduced(int amount) {
        this.producedProducts += amount;
        HFApi.animals.syncAnimalStats(this.animal);
    }

    @Override
    public boolean performTest(AnimalTest test) {
        if (test == AnimalTest.HAS_EATEN) {
            return this.daysNotFed < 0;
        }
        if (test == AnimalTest.IS_SICK) {
            return this.isSick;
        }
        if (test == AnimalTest.HAD_TREAT) {
            return this.treated;
        }
        return false;
    }

    @Override
    public boolean performAction(@Nonnull World world, @Nullable EntityPlayer player, @Nullable ItemStack stack, AnimalAction action) {
        if (action == AnimalAction.FEED) {
            return this.feed(world, player);
        }
        if (action == AnimalAction.HEAL) {
            return this.heal(world, player);
        }
        return (action == AnimalAction.TREAT_SPECIAL || action == AnimalAction.TREAT_GENERIC) && this.treat(world, player, stack);
    }

    private boolean feed(@Nonnull World world, @Nullable EntityPlayer player) {
        if (this.daysNotFed >= 0) {
            if (!world.field_72995_K) {
                this.daysNotFed = -1;
                this.affectRelationship(player, this.type.getRelationshipBonus(AnimalAction.FEED));
                HFApi.animals.syncAnimalStats(this.animal);
            }
            return true;
        }
        return false;
    }

    private boolean heal(@Nonnull World world, @Nullable EntityPlayer player) {
        if (this.healthiness < 27) {
            this.animal.func_70674_bp();
            if (!world.field_72995_K) {
                this.healthiness = 127;
                this.isSick = false;
                this.affectRelationship(player, -100);
                HFApi.animals.syncAnimalStats(this.animal);
            }
            return true;
        }
        return false;
    }

    @Override
    public void affectRelationship(EntityPlayer player, int amount) {
        if (player != null && amount != 0) {
            HFApi.player.getRelationsForPlayer(player).affectRelationship(RelationshipType.ANIMAL, EntityHelper.getEntityUUID((Entity)this.animal), amount);
            if (amount < 0) {
                try {
                    ReflectionHelper.findMethod(EntityLivingBase.class, null, (String[])new String[]{"playHurtSound"}, (Class[])new Class[]{DamageSource.class}).invoke((Object)this.animal, DamageSource.field_76366_f);
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void treat(EntityPlayer player, AnimalAction action) {
        this.treated = true;
        this.affectRelationship(player, this.type.getRelationshipBonus(action));
        HFApi.animals.syncAnimalStats(this.animal);
    }

    private boolean treat(@Nonnull World world, @Nullable EntityPlayer player, @Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (!this.treated) {
            if (HFAnimals.TREATS.getEnumFromStack(stack) == ItemAnimalTreat.Treat.GENERIC) {
                if (!world.field_72995_K) {
                    ++this.genericTreats;
                    this.treat(player, AnimalAction.TREAT_GENERIC);
                }
                return true;
            }
            if (((ItemAnimalTreat.Treat)((Object)HFAnimals.TREATS.getEnumFromStack(stack))).getType() == this.type) {
                if (!world.field_72995_K) {
                    ++this.typeTreats;
                    this.treat(player, AnimalAction.TREAT_SPECIAL);
                }
                return true;
            }
            if (!world.field_72995_K) {
                this.treat(player, AnimalAction.TREAT_INCORRECT);
            }
            return true;
        }
        return false;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Owner")) {
            this.o_uuid = UUID.fromString(nbt.func_74779_i("Owner"));
        }
        this.currentLifespan = nbt.func_74765_d("CurrentLifespan");
        this.healthiness = nbt.func_74771_c("Healthiness");
        this.stress = nbt.func_74771_c("Stress");
        this.daysNotFed = nbt.func_74771_c("DaysNotFed");
        this.daysPassed = nbt.func_74771_c("DaysPassed");
        this.treated = nbt.func_74767_n("Treated");
        this.genericTreats = nbt.func_74765_d("GenericTreats");
        this.typeTreats = nbt.func_74765_d("TypeTreats");
        this.wasSick = nbt.func_74767_n("WasSick");
        this.isSick = nbt.func_74767_n("IsSick");
        this.wasOutsideInSun = nbt.func_74767_n("WasOutsideInSun");
        if (this.type.getDaysBetweenProduction() > 0) {
            this.productsPerDay = nbt.func_74771_c("NumProducts");
            this.producedProducts = nbt.func_74771_c("ProducedProducts");
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.o_uuid != null) {
            tag.func_74778_a("Owner", this.o_uuid.toString());
        }
        tag.func_74777_a("CurrentLifespan", (short)this.currentLifespan);
        tag.func_74774_a("Healthiness", (byte)this.healthiness);
        tag.func_74774_a("Stress", (byte)this.stress);
        tag.func_74774_a("DaysNotFed", (byte)this.daysNotFed);
        tag.func_74774_a("DaysPassed", (byte)this.daysPassed);
        tag.func_74757_a("Treated", this.treated);
        tag.func_74777_a("GenericTreats", (short)this.genericTreats);
        tag.func_74777_a("TypeTreats", (short)this.typeTreats);
        tag.func_74757_a("WasSick", this.wasSick);
        tag.func_74757_a("IsSick", this.isSick);
        tag.func_74757_a("WasOutsideInSun", this.wasOutsideInSun);
        if (this.type.getDaysBetweenProduction() > 0) {
            tag.func_74774_a("NumProducts", (byte)this.productsPerDay);
            tag.func_74774_a("ProducedProducts", (byte)this.producedProducts);
        }
        return tag;
    }
}

