/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals.packet;

import io.netty.buffer.ByteBuf;
import joshie.harvest.api.animals.AnimalStats;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.helpers.MCClientHelper;
import joshie.harvest.core.network.Packet;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.network.PenguinPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

@Packet
public class PacketSyncAnimal
extends PenguinPacket {
    private int id;
    private NBTTagCompound tag;

    public PacketSyncAnimal() {
    }

    public PacketSyncAnimal(int id) {
        this.id = id;
    }

    public PacketSyncAnimal(int id, AnimalStats stats) {
        this.id = id;
        this.tag = (NBTTagCompound)stats.serializeNBT();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.tag != null);
        if (this.tag != null) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        if (buf.readBoolean()) {
            this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        }
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        AnimalStats stats;
        EntityAnimal animal = (EntityAnimal)MCClientHelper.getWorld().func_73045_a(this.id);
        if (animal != null && (stats = EntityHelper.getStats((Entity)animal)) != null) {
            if (player.field_70170_p.field_72995_K) {
                stats.setEntity(animal).deserializeNBT((NBTBase)this.tag);
            } else {
                PacketHandler.sendToClient(new PacketSyncAnimal(this.id, stats), player);
            }
        }
    }

    private EntityAnimal getEntityAsAnimal() {
        return (EntityAnimal)MCClientHelper.getWorld().func_73045_a(this.id);
    }
}

