/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals.item;

import java.util.HashMap;
import java.util.Locale;
import joshie.harvest.api.animals.IAnimalData;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.api.animals.IMilkable;
import joshie.harvest.api.core.IShippable;
import joshie.harvest.core.base.item.ItemHFEnum;
import joshie.harvest.tools.ToolHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAnimalTool
extends ItemHFEnum<ItemAnimalTool, Tool>
implements IShippable {
    private static final double MAX_DAMAGE = 512.0;
    private final HashMap<EntityPlayer, IMilkable> milkables = new HashMap();

    public ItemAnimalTool() {
        super(Tool.class);
    }

    @Override
    public long getSellValue(ItemStack stack) {
        return this.getEnumFromStack(stack) == Tool.CHICKEN_FEED ? 1L : 0L;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77626_a(ItemStack stack) {
        return this.getEnumFromStack(stack) == Tool.MILKER ? 32 : 0;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.getEnumFromStack(stack) == Tool.MILKER ? EnumAction.BOW : EnumAction.NONE;
    }

    public ItemStack func_77654_b(ItemStack held, World world, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer && this.getEnumFromStack(held) == Tool.MILKER) {
            int damage;
            EntityPlayer player = (EntityPlayer)entityLiving;
            IMilkable milkable = this.milkables.get(player);
            if (milkable != null) {
                milkable.milk(player);
            }
            if ((double)(damage = this.getDamageForDisplay(held) + 1) >= 512.0) {
                held.func_77979_a(1);
            } else {
                held.func_179543_a("Data", true).func_74768_a("Damage", damage);
            }
            ToolHelper.consumeHunger(player, 4.0f);
        }
        return held;
    }

    private boolean milk(EntityPlayer player, EnumHand hand, IMilkable milkable) {
        if (milkable.canMilk()) {
            this.milkables.put(player, milkable);
            player.func_184598_c(hand);
            return true;
        }
        return false;
    }

    private boolean impregnate(EntityPlayer player, EntityAnimal animal, IAnimalData data, ItemStack stack) {
        if (!animal.field_70170_p.field_72995_K && data.impregnate(player)) {
            --stack.field_77994_a;
        }
        return true;
    }

    private boolean heal(EntityPlayer player, IAnimalData data, ItemStack stack) {
        if (!player.field_70170_p.field_72995_K && data.heal(player)) {
            --stack.field_77994_a;
        }
        ToolHelper.consumeHunger(player, 5.0f);
        return true;
    }

    private boolean clean(EntityPlayer player, ItemStack held, EntityAnimal animal, IAnimalData data) {
        if (!player.field_70170_p.field_72995_K) {
            data.clean(player);
        } else {
            int j = 0;
            while ((double)j < 30.0) {
                double d7 = animal.field_70163_u - 0.5 + (double)animal.field_70170_p.field_73012_v.nextFloat();
                double d8 = animal.field_70165_t - 0.5 + (double)animal.field_70170_p.field_73012_v.nextFloat();
                double d9 = animal.field_70161_v - 0.5 + (double)animal.field_70170_p.field_73012_v.nextFloat();
                animal.field_70170_p.func_175688_a(EnumParticleTypes.TOWN_AURA, d8, 1.0 + d7 - 0.125, d9, 0.0, 0.0, 0.0, new int[0]);
                ++j;
            }
        }
        int damage = this.getDamageForDisplay(held) + 1;
        if ((double)damage >= 512.0) {
            held.func_77979_a(1);
        } else {
            held.func_179543_a("Data", true).func_74768_a("Damage", damage);
        }
        ToolHelper.consumeHunger(player, 4.0f);
        return true;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase living, EnumHand hand) {
        if (living instanceof IAnimalTracked) {
            IAnimalData data = ((IAnimalTracked)living).getData();
            Tool tool = (Tool)((Object)this.getEnumFromStack(stack));
            if (tool == Tool.BRUSH && !(living instanceof EntityChicken)) {
                return this.clean(player, stack, (EntityAnimal)living, data);
            }
            if (tool == Tool.MEDICINE) {
                return this.heal(player, data, stack);
            }
            if (tool == Tool.MIRACLE_POTION && !(living instanceof EntityChicken)) {
                return this.impregnate(player, (EntityAnimal)living, data, stack);
            }
            if (tool == Tool.MILKER && living instanceof IMilkable) {
                return this.milk(player, hand, (IMilkable)living);
            }
        }
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurabilityForDisplay(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return this.canBeDamaged(stack) ? (double)this.getDamageForDisplay(stack) / 512.0 : 0.0;
    }

    protected int getDamageForDisplay(ItemStack stack) {
        return stack.func_179543_a("Data", true).func_74762_e("Damage");
    }

    public boolean canBeDamaged(ItemStack stack) {
        return ((Tool)((Object)this.getEnumFromStack(stack))).isDamageable;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return (this.getEnumFromStack(stack) == Tool.MIRACLE_POTION ? TextFormatting.AQUA : "") + super.func_77653_i(stack);
    }

    @Override
    protected String getPrefix(Tool tool) {
        return "animal_tool";
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 102;
    }

    public static enum Tool implements IStringSerializable
    {
        MILKER(true),
        BRUSH(true),
        MEDICINE(false),
        CHICKEN_FEED(false),
        MIRACLE_POTION(false);

        private final boolean isDamageable;

        private Tool(boolean isDamageable) {
            this.isDamageable = isDamageable;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

