/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.animals.entity;

import io.netty.buffer.ByteBuf;
import joshie.harvest.animals.HFAnimals;
import joshie.harvest.animals.entity.EntityAIEat;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.IAnimalData;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.api.animals.IMilkable;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.achievements.HFAchievements;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.SizeableHelper;
import joshie.harvest.player.PlayerTracker;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityHarvestCow
extends EntityCow
implements IAnimalTracked,
IMilkable {
    private final IAnimalData data;

    public EntityHarvestCow(World world) {
        super(world);
        this.func_70105_a(1.4f, 1.4f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.data = HFApi.animals.newData(this, "cow");
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Items.field_151015_O, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIEat(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0, true, false));
        return super.func_70097_a(source, amount);
    }

    @Override
    public IAnimalData getData() {
        return this.data;
    }

    @Override
    public boolean canMilk() {
        return !this.func_70631_g_() && this.data.canProduce();
    }

    @Override
    public void milk(EntityPlayer player) {
        ItemStack product = SizeableHelper.getMilk(player, this);
        if (!player.field_71071_by.func_70441_a(product)) {
            player.func_71019_a(product, false);
        }
        if (!this.field_70170_p.field_72995_K && !HFAnimals.OP_ANIMALS) {
            this.data.setProduced(this.getData().getProductsPerDay());
        }
        player.func_71029_a((StatBase)HFAchievements.milker);
        if (HFCore.SIZEABLE.getSize(product) == ISizeable.Size.LARGE) {
            player.func_71029_a((StatBase)HFAchievements.milkerLarge);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (stack != null) {
            if (HFApi.animals.canEat(stack, this.data.getType().getFoodTypes())) {
                if (this.data.isHungry()) {
                    stack.func_77979_a(1);
                    if (!this.field_70170_p.field_72995_K) {
                        this.data.feed(player);
                    }
                }
                return true;
            }
            return false;
        }
        if (this.field_70170_p.field_73012_v.nextFloat() < 0.33f) {
            SoundEvent s = this.func_184639_G();
            if (s != null) {
                this.func_184185_a(s, 2.0f, this.func_70647_i());
            }
            ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getRelationships().talkTo(player, this.getUUID());
            return true;
        }
        return false;
    }

    public EntityCow func_90011_a(EntityAgeable ageable) {
        return new EntityHarvestCow(this.field_70170_p);
    }

    public void writeSpawnData(ByteBuf buffer) {
        this.data.toBytes(buffer);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.data.fromBytes(buffer);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.data.readFromNBT(nbt);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.data.writeToNBT(nbt);
    }
}

